/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dashboard.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dashboard.models.ManagedPrivateEndpointConnectionState;
import com.azure.resourcemanager.dashboard.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class ManagedPrivateEndpointModelProperties
implements JsonSerializable<ManagedPrivateEndpointModelProperties> {
    private ProvisioningState provisioningState;
    private String privateLinkResourceId;
    private String privateLinkResourceRegion;
    private List<String> groupIds;
    private String requestMessage;
    private ManagedPrivateEndpointConnectionState connectionState;
    private String privateLinkServiceUrl;
    private String privateLinkServicePrivateIp;

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String privateLinkResourceId() {
        return this.privateLinkResourceId;
    }

    public ManagedPrivateEndpointModelProperties withPrivateLinkResourceId(String privateLinkResourceId) {
        this.privateLinkResourceId = privateLinkResourceId;
        return this;
    }

    public String privateLinkResourceRegion() {
        return this.privateLinkResourceRegion;
    }

    public ManagedPrivateEndpointModelProperties withPrivateLinkResourceRegion(String privateLinkResourceRegion) {
        this.privateLinkResourceRegion = privateLinkResourceRegion;
        return this;
    }

    public List<String> groupIds() {
        return this.groupIds;
    }

    public ManagedPrivateEndpointModelProperties withGroupIds(List<String> groupIds) {
        this.groupIds = groupIds;
        return this;
    }

    public String requestMessage() {
        return this.requestMessage;
    }

    public ManagedPrivateEndpointModelProperties withRequestMessage(String requestMessage) {
        this.requestMessage = requestMessage;
        return this;
    }

    public ManagedPrivateEndpointConnectionState connectionState() {
        return this.connectionState;
    }

    public String privateLinkServiceUrl() {
        return this.privateLinkServiceUrl;
    }

    public ManagedPrivateEndpointModelProperties withPrivateLinkServiceUrl(String privateLinkServiceUrl) {
        this.privateLinkServiceUrl = privateLinkServiceUrl;
        return this;
    }

    public String privateLinkServicePrivateIp() {
        return this.privateLinkServicePrivateIp;
    }

    public void validate() {
        if (this.connectionState() != null) {
            this.connectionState().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("privateLinkResourceId", this.privateLinkResourceId);
        jsonWriter.writeStringField("privateLinkResourceRegion", this.privateLinkResourceRegion);
        jsonWriter.writeArrayField("groupIds", this.groupIds, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("requestMessage", this.requestMessage);
        jsonWriter.writeStringField("privateLinkServiceUrl", this.privateLinkServiceUrl);
        return jsonWriter.writeEndObject();
    }

    public static ManagedPrivateEndpointModelProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedPrivateEndpointModelProperties)jsonReader.readObject(reader -> {
            ManagedPrivateEndpointModelProperties deserializedManagedPrivateEndpointModelProperties = new ManagedPrivateEndpointModelProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedManagedPrivateEndpointModelProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("privateLinkResourceId".equals(fieldName)) {
                    deserializedManagedPrivateEndpointModelProperties.privateLinkResourceId = reader.getString();
                    continue;
                }
                if ("privateLinkResourceRegion".equals(fieldName)) {
                    deserializedManagedPrivateEndpointModelProperties.privateLinkResourceRegion = reader.getString();
                    continue;
                }
                if ("groupIds".equals(fieldName)) {
                    List groupIds;
                    deserializedManagedPrivateEndpointModelProperties.groupIds = groupIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("requestMessage".equals(fieldName)) {
                    deserializedManagedPrivateEndpointModelProperties.requestMessage = reader.getString();
                    continue;
                }
                if ("connectionState".equals(fieldName)) {
                    deserializedManagedPrivateEndpointModelProperties.connectionState = ManagedPrivateEndpointConnectionState.fromJson(reader);
                    continue;
                }
                if ("privateLinkServiceUrl".equals(fieldName)) {
                    deserializedManagedPrivateEndpointModelProperties.privateLinkServiceUrl = reader.getString();
                    continue;
                }
                if ("privateLinkServicePrivateIP".equals(fieldName)) {
                    deserializedManagedPrivateEndpointModelProperties.privateLinkServicePrivateIp = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedPrivateEndpointModelProperties;
        });
    }
}

