/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dashboard.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dashboard.models.AvailablePromotion;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class MarketplaceTrialQuota
implements JsonSerializable<MarketplaceTrialQuota> {
    private AvailablePromotion availablePromotion;
    private String grafanaResourceId;
    private OffsetDateTime trialStartAt;
    private OffsetDateTime trialEndAt;

    private MarketplaceTrialQuota() {
    }

    public AvailablePromotion availablePromotion() {
        return this.availablePromotion;
    }

    public String grafanaResourceId() {
        return this.grafanaResourceId;
    }

    public OffsetDateTime trialStartAt() {
        return this.trialStartAt;
    }

    public OffsetDateTime trialEndAt() {
        return this.trialEndAt;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("availablePromotion", this.availablePromotion == null ? null : this.availablePromotion.toString());
        jsonWriter.writeStringField("grafanaResourceId", this.grafanaResourceId);
        jsonWriter.writeStringField("trialStartAt", this.trialStartAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.trialStartAt));
        jsonWriter.writeStringField("trialEndAt", this.trialEndAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.trialEndAt));
        return jsonWriter.writeEndObject();
    }

    public static MarketplaceTrialQuota fromJson(JsonReader jsonReader) throws IOException {
        return (MarketplaceTrialQuota)jsonReader.readObject(reader -> {
            MarketplaceTrialQuota deserializedMarketplaceTrialQuota = new MarketplaceTrialQuota();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("availablePromotion".equals(fieldName)) {
                    deserializedMarketplaceTrialQuota.availablePromotion = AvailablePromotion.fromString(reader.getString());
                    continue;
                }
                if ("grafanaResourceId".equals(fieldName)) {
                    deserializedMarketplaceTrialQuota.grafanaResourceId = reader.getString();
                    continue;
                }
                if ("trialStartAt".equals(fieldName)) {
                    deserializedMarketplaceTrialQuota.trialStartAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("trialEndAt".equals(fieldName)) {
                    deserializedMarketplaceTrialQuota.trialEndAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMarketplaceTrialQuota;
        });
    }
}

