/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dashboard.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dashboard.fluent.models.ManagedGrafanaInner;
import com.azure.resourcemanager.dashboard.models.EnterpriseDetails;
import com.azure.resourcemanager.dashboard.models.GrafanaAvailablePluginListResponse;
import com.azure.resourcemanager.dashboard.models.ManagedGrafanaProperties;
import com.azure.resourcemanager.dashboard.models.ManagedGrafanaPropertiesUpdateParameters;
import com.azure.resourcemanager.dashboard.models.ManagedServiceIdentity;
import com.azure.resourcemanager.dashboard.models.ResourceSku;
import java.util.Map;

public interface ManagedGrafana {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public ResourceSku sku();

    public ManagedGrafanaProperties properties();

    public ManagedServiceIdentity identity();

    public SystemData systemData();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public ManagedGrafanaInner innerModel();

    public Update update();

    public ManagedGrafana refresh();

    public ManagedGrafana refresh(Context var1);

    public Response<EnterpriseDetails> checkEnterpriseDetailsWithResponse(Context var1);

    public EnterpriseDetails checkEnterpriseDetails();

    public Response<GrafanaAvailablePluginListResponse> fetchAvailablePluginsWithResponse(Context var1);

    public GrafanaAvailablePluginListResponse fetchAvailablePlugins();

    public static interface UpdateStages {

        public static interface WithProperties {
            public Update withProperties(ManagedGrafanaPropertiesUpdateParameters var1);
        }

        public static interface WithIdentity {
            public Update withIdentity(ManagedServiceIdentity var1);
        }

        public static interface WithSku {
            public Update withSku(ResourceSku var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithSku,
    UpdateStages.WithIdentity,
    UpdateStages.WithProperties {
        public ManagedGrafana apply();

        public ManagedGrafana apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIdentity {
            public WithCreate withIdentity(ManagedServiceIdentity var1);
        }

        public static interface WithProperties {
            public WithCreate withProperties(ManagedGrafanaProperties var1);
        }

        public static interface WithSku {
            public WithCreate withSku(ResourceSku var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithSku,
        WithProperties,
        WithIdentity {
            public ManagedGrafana create();

            public ManagedGrafana create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

