/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dashboard.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.dashboard.fluent.ManagedDashboardsClient;
import com.azure.resourcemanager.dashboard.fluent.models.ManagedDashboardInner;
import com.azure.resourcemanager.dashboard.implementation.DashboardManagementClientImpl;
import com.azure.resourcemanager.dashboard.implementation.models.ManagedDashboardListResponse;
import com.azure.resourcemanager.dashboard.models.ManagedDashboardUpdateParameters;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ManagedDashboardsClientImpl
implements ManagedDashboardsClient {
    private final ManagedDashboardsService service;
    private final DashboardManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedDashboardsClientImpl.class);

    ManagedDashboardsClientImpl(DashboardManagementClientImpl client) {
        this.service = (ManagedDashboardsService)RestProxy.create(ManagedDashboardsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ManagedDashboardInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String dashboardName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dashboardName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dashboardName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dashboardName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ManagedDashboardInner> getByResourceGroupAsync(String resourceGroupName, String dashboardName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, dashboardName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ManagedDashboardInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ManagedDashboardInner> getByResourceGroupWithResponse(String resourceGroupName, String dashboardName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dashboardName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter dashboardName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getByResourceGroupSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dashboardName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedDashboardInner getByResourceGroup(String resourceGroupName, String dashboardName) {
        return (ManagedDashboardInner)((Object)this.getByResourceGroupWithResponse(resourceGroupName, dashboardName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String dashboardName, ManagedDashboardInner requestBodyParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dashboardName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dashboardName is required and cannot be null."));
        }
        if (requestBodyParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter requestBodyParameters is required and cannot be null."));
        }
        requestBodyParameters.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dashboardName, "application/json", "application/json", requestBodyParameters, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createWithResponse(String resourceGroupName, String dashboardName, ManagedDashboardInner requestBodyParameters) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dashboardName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter dashboardName is required and cannot be null."));
        }
        if (requestBodyParameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter requestBodyParameters is required and cannot be null."));
        }
        requestBodyParameters.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dashboardName, "application/json", "application/json", requestBodyParameters, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createWithResponse(String resourceGroupName, String dashboardName, ManagedDashboardInner requestBodyParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dashboardName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter dashboardName is required and cannot be null."));
        }
        if (requestBodyParameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter requestBodyParameters is required and cannot be null."));
        }
        requestBodyParameters.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dashboardName, "application/json", "application/json", requestBodyParameters, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ManagedDashboardInner>, ManagedDashboardInner> beginCreateAsync(String resourceGroupName, String dashboardName, ManagedDashboardInner requestBodyParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, dashboardName, requestBodyParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ManagedDashboardInner.class), (Type)((Object)ManagedDashboardInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ManagedDashboardInner>, ManagedDashboardInner> beginCreate(String resourceGroupName, String dashboardName, ManagedDashboardInner requestBodyParameters) {
        Response<BinaryData> response = this.createWithResponse(resourceGroupName, dashboardName, requestBodyParameters);
        return this.client.getLroResult(response, (Type)((Object)ManagedDashboardInner.class), (Type)((Object)ManagedDashboardInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ManagedDashboardInner>, ManagedDashboardInner> beginCreate(String resourceGroupName, String dashboardName, ManagedDashboardInner requestBodyParameters, Context context) {
        Response<BinaryData> response = this.createWithResponse(resourceGroupName, dashboardName, requestBodyParameters, context);
        return this.client.getLroResult(response, (Type)((Object)ManagedDashboardInner.class), (Type)((Object)ManagedDashboardInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ManagedDashboardInner> createAsync(String resourceGroupName, String dashboardName, ManagedDashboardInner requestBodyParameters) {
        return this.beginCreateAsync(resourceGroupName, dashboardName, requestBodyParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedDashboardInner create(String resourceGroupName, String dashboardName, ManagedDashboardInner requestBodyParameters) {
        return (ManagedDashboardInner)((Object)this.beginCreate(resourceGroupName, dashboardName, requestBodyParameters).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedDashboardInner create(String resourceGroupName, String dashboardName, ManagedDashboardInner requestBodyParameters, Context context) {
        return (ManagedDashboardInner)((Object)this.beginCreate(resourceGroupName, dashboardName, requestBodyParameters, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ManagedDashboardInner>> updateWithResponseAsync(String resourceGroupName, String dashboardName, ManagedDashboardUpdateParameters requestBodyParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dashboardName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dashboardName is required and cannot be null."));
        }
        if (requestBodyParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter requestBodyParameters is required and cannot be null."));
        }
        requestBodyParameters.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dashboardName, "application/json", "application/json", requestBodyParameters, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ManagedDashboardInner> updateAsync(String resourceGroupName, String dashboardName, ManagedDashboardUpdateParameters requestBodyParameters) {
        return this.updateWithResponseAsync(resourceGroupName, dashboardName, requestBodyParameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ManagedDashboardInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ManagedDashboardInner> updateWithResponse(String resourceGroupName, String dashboardName, ManagedDashboardUpdateParameters requestBodyParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dashboardName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter dashboardName is required and cannot be null."));
        }
        if (requestBodyParameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter requestBodyParameters is required and cannot be null."));
        }
        requestBodyParameters.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dashboardName, "application/json", "application/json", requestBodyParameters, context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedDashboardInner update(String resourceGroupName, String dashboardName, ManagedDashboardUpdateParameters requestBodyParameters) {
        return (ManagedDashboardInner)((Object)this.updateWithResponse(resourceGroupName, dashboardName, requestBodyParameters, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String dashboardName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dashboardName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dashboardName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dashboardName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String dashboardName) {
        return this.deleteWithResponseAsync(resourceGroupName, dashboardName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String dashboardName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dashboardName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter dashboardName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dashboardName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String dashboardName) {
        this.deleteWithResponse(resourceGroupName, dashboardName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedDashboardInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedDashboardListResponse)res.getValue()).value(), ((ManagedDashboardListResponse)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ManagedDashboardInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ManagedDashboardInner> listByResourceGroupSinglePage(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ManagedDashboardListResponse> res = this.service.listByResourceGroupSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedDashboardListResponse)res.getValue()).value(), ((ManagedDashboardListResponse)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ManagedDashboardInner> listByResourceGroupSinglePage(String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ManagedDashboardListResponse> res = this.service.listByResourceGroupSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedDashboardListResponse)res.getValue()).value(), ((ManagedDashboardListResponse)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ManagedDashboardInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(() -> this.listByResourceGroupSinglePage(resourceGroupName), nextLink -> this.listNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ManagedDashboardInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable(() -> this.listByResourceGroupSinglePage(resourceGroupName, context), nextLink -> this.listNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedDashboardInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedDashboardListResponse)res.getValue()).value(), ((ManagedDashboardListResponse)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ManagedDashboardInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync(), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ManagedDashboardInner> listSinglePage() {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ManagedDashboardListResponse> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedDashboardListResponse)res.getValue()).value(), ((ManagedDashboardListResponse)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ManagedDashboardInner> listSinglePage(Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ManagedDashboardListResponse> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedDashboardListResponse)res.getValue()).value(), ((ManagedDashboardListResponse)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ManagedDashboardInner> list() {
        return new PagedIterable(() -> this.listSinglePage(), nextLink -> this.listBySubscriptionNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ManagedDashboardInner> list(Context context) {
        return new PagedIterable(() -> this.listSinglePage(context), nextLink -> this.listBySubscriptionNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedDashboardInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedDashboardListResponse)res.getValue()).value(), ((ManagedDashboardListResponse)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ManagedDashboardInner> listNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ManagedDashboardListResponse> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedDashboardListResponse)res.getValue()).value(), ((ManagedDashboardListResponse)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ManagedDashboardInner> listNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ManagedDashboardListResponse> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedDashboardListResponse)res.getValue()).value(), ((ManagedDashboardListResponse)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedDashboardInner>> listBySubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedDashboardListResponse)res.getValue()).value(), ((ManagedDashboardListResponse)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ManagedDashboardInner> listBySubscriptionNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ManagedDashboardListResponse> res = this.service.listBySubscriptionNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedDashboardListResponse)res.getValue()).value(), ((ManagedDashboardListResponse)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ManagedDashboardInner> listBySubscriptionNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ManagedDashboardListResponse> res = this.service.listBySubscriptionNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedDashboardListResponse)res.getValue()).value(), ((ManagedDashboardListResponse)res.getValue()).nextLink(), null);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="DashboardManagementClientManagedDashboards")
    public static interface ManagedDashboardsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/dashboards/{dashboardName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedDashboardInner>> getByResourceGroup(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dashboardName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/dashboards/{dashboardName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ManagedDashboardInner> getByResourceGroupSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dashboardName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/dashboards/{dashboardName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dashboardName") String var5, @HeaderParam(value="Content-Type") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") ManagedDashboardInner var8, Context var9);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/dashboards/{dashboardName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dashboardName") String var5, @HeaderParam(value="Content-Type") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") ManagedDashboardInner var8, Context var9);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/dashboards/{dashboardName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedDashboardInner>> update(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dashboardName") String var5, @HeaderParam(value="Content-Type") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") ManagedDashboardUpdateParameters var8, Context var9);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/dashboards/{dashboardName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ManagedDashboardInner> updateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dashboardName") String var5, @HeaderParam(value="Content-Type") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") ManagedDashboardUpdateParameters var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/dashboards/{dashboardName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dashboardName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/dashboards/{dashboardName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<Void> deleteSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dashboardName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/dashboards")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedDashboardListResponse>> listByResourceGroup(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/dashboards")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ManagedDashboardListResponse> listByResourceGroupSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Dashboard/dashboards")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedDashboardListResponse>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Dashboard/dashboards")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ManagedDashboardListResponse> listSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedDashboardListResponse>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ManagedDashboardListResponse> listNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedDashboardListResponse>> listBySubscriptionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ManagedDashboardListResponse> listBySubscriptionNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

