/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dashboard.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dashboard.DashboardManager;
import com.azure.resourcemanager.dashboard.fluent.models.ManagedDashboardInner;
import com.azure.resourcemanager.dashboard.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dashboard.models.ManagedDashboard;
import com.azure.resourcemanager.dashboard.models.ManagedDashboardUpdateParameters;
import com.azure.resourcemanager.dashboard.models.ProvisioningState;
import java.util.Collections;
import java.util.Map;

public final class ManagedDashboardImpl
implements ManagedDashboard,
ManagedDashboard.Definition,
ManagedDashboard.Update {
    private ManagedDashboardInner innerObject;
    private final DashboardManager serviceManager;
    private String resourceGroupName;
    private String dashboardName;
    private ManagedDashboardUpdateParameters updateRequestBodyParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ManagedDashboardInner innerModel() {
        return this.innerObject;
    }

    private DashboardManager manager() {
        return this.serviceManager;
    }

    @Override
    public ManagedDashboardImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public ManagedDashboard create() {
        this.innerObject = this.serviceManager.serviceClient().getManagedDashboards().create(this.resourceGroupName, this.dashboardName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ManagedDashboard create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getManagedDashboards().create(this.resourceGroupName, this.dashboardName, this.innerModel(), context);
        return this;
    }

    ManagedDashboardImpl(String name, DashboardManager serviceManager) {
        this.innerObject = new ManagedDashboardInner();
        this.serviceManager = serviceManager;
        this.dashboardName = name;
    }

    @Override
    public ManagedDashboardImpl update() {
        this.updateRequestBodyParameters = new ManagedDashboardUpdateParameters();
        return this;
    }

    @Override
    public ManagedDashboard apply() {
        this.innerObject = (ManagedDashboardInner)((Object)this.serviceManager.serviceClient().getManagedDashboards().updateWithResponse(this.resourceGroupName, this.dashboardName, this.updateRequestBodyParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public ManagedDashboard apply(Context context) {
        this.innerObject = (ManagedDashboardInner)((Object)this.serviceManager.serviceClient().getManagedDashboards().updateWithResponse(this.resourceGroupName, this.dashboardName, this.updateRequestBodyParameters, context).getValue());
        return this;
    }

    ManagedDashboardImpl(ManagedDashboardInner innerObject, DashboardManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.dashboardName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "dashboards");
    }

    @Override
    public ManagedDashboard refresh() {
        this.innerObject = (ManagedDashboardInner)((Object)this.serviceManager.serviceClient().getManagedDashboards().getByResourceGroupWithResponse(this.resourceGroupName, this.dashboardName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ManagedDashboard refresh(Context context) {
        this.innerObject = (ManagedDashboardInner)((Object)this.serviceManager.serviceClient().getManagedDashboards().getByResourceGroupWithResponse(this.resourceGroupName, this.dashboardName, context).getValue());
        return this;
    }

    @Override
    public ManagedDashboardImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ManagedDashboardImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ManagedDashboardImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateRequestBodyParameters.withTags(tags);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

