/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservicefleet.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservicefleet.models.UpdateGroup;
import java.io.IOException;
import java.util.List;

public final class UpdateStage
implements JsonSerializable<UpdateStage> {
    private String name;
    private List<UpdateGroup> groups;
    private Integer afterStageWaitInSeconds;
    private static final ClientLogger LOGGER = new ClientLogger(UpdateStage.class);

    public String name() {
        return this.name;
    }

    public UpdateStage withName(String name) {
        this.name = name;
        return this;
    }

    public List<UpdateGroup> groups() {
        return this.groups;
    }

    public UpdateStage withGroups(List<UpdateGroup> groups) {
        this.groups = groups;
        return this;
    }

    public Integer afterStageWaitInSeconds() {
        return this.afterStageWaitInSeconds;
    }

    public UpdateStage withAfterStageWaitInSeconds(Integer afterStageWaitInSeconds) {
        this.afterStageWaitInSeconds = afterStageWaitInSeconds;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model UpdateStage"));
        }
        if (this.groups() != null) {
            this.groups().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("groups", this.groups, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("afterStageWaitInSeconds", (Number)this.afterStageWaitInSeconds);
        return jsonWriter.writeEndObject();
    }

    public static UpdateStage fromJson(JsonReader jsonReader) throws IOException {
        return (UpdateStage)jsonReader.readObject(reader -> {
            UpdateStage deserializedUpdateStage = new UpdateStage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedUpdateStage.name = reader.getString();
                    continue;
                }
                if ("groups".equals(fieldName)) {
                    List groups;
                    deserializedUpdateStage.groups = groups = reader.readArray(reader1 -> UpdateGroup.fromJson(reader1));
                    continue;
                }
                if ("afterStageWaitInSeconds".equals(fieldName)) {
                    deserializedUpdateStage.afterStageWaitInSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUpdateStage;
        });
    }
}

