/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservicefleet.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservicefleet.models.TargetType;
import java.io.IOException;

public final class SkipTarget
implements JsonSerializable<SkipTarget> {
    private TargetType type;
    private String name;
    private static final ClientLogger LOGGER = new ClientLogger(SkipTarget.class);

    public TargetType type() {
        return this.type;
    }

    public SkipTarget withType(TargetType type) {
        this.type = type;
        return this;
    }

    public String name() {
        return this.name;
    }

    public SkipTarget withName(String name) {
        this.name = name;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model SkipTarget"));
        }
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model SkipTarget"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static SkipTarget fromJson(JsonReader jsonReader) throws IOException {
        return (SkipTarget)jsonReader.readObject(reader -> {
            SkipTarget deserializedSkipTarget = new SkipTarget();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedSkipTarget.type = TargetType.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSkipTarget.name = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSkipTarget;
        });
    }
}

