/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservicefleet.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservicefleet.models.SkipTarget;
import java.io.IOException;
import java.util.List;

public final class SkipProperties
implements JsonSerializable<SkipProperties> {
    private List<SkipTarget> targets;
    private static final ClientLogger LOGGER = new ClientLogger(SkipProperties.class);

    public List<SkipTarget> targets() {
        return this.targets;
    }

    public SkipProperties withTargets(List<SkipTarget> targets) {
        this.targets = targets;
        return this;
    }

    public void validate() {
        if (this.targets() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targets in model SkipProperties"));
        }
        this.targets().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("targets", this.targets, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SkipProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SkipProperties)jsonReader.readObject(reader -> {
            SkipProperties deserializedSkipProperties = new SkipProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targets".equals(fieldName)) {
                    List targets;
                    deserializedSkipProperties.targets = targets = reader.readArray(reader1 -> SkipTarget.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSkipProperties;
        });
    }
}

