/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservicefleet.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservicefleet.models.ManagedClusterUpgradeType;
import java.io.IOException;

public final class ManagedClusterUpgradeSpec
implements JsonSerializable<ManagedClusterUpgradeSpec> {
    private ManagedClusterUpgradeType type;
    private String kubernetesVersion;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedClusterUpgradeSpec.class);

    public ManagedClusterUpgradeType type() {
        return this.type;
    }

    public ManagedClusterUpgradeSpec withType(ManagedClusterUpgradeType type) {
        this.type = type;
        return this;
    }

    public String kubernetesVersion() {
        return this.kubernetesVersion;
    }

    public ManagedClusterUpgradeSpec withKubernetesVersion(String kubernetesVersion) {
        this.kubernetesVersion = kubernetesVersion;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model ManagedClusterUpgradeSpec"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("kubernetesVersion", this.kubernetesVersion);
        return jsonWriter.writeEndObject();
    }

    public static ManagedClusterUpgradeSpec fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedClusterUpgradeSpec)jsonReader.readObject(reader -> {
            ManagedClusterUpgradeSpec deserializedManagedClusterUpgradeSpec = new ManagedClusterUpgradeSpec();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedManagedClusterUpgradeSpec.type = ManagedClusterUpgradeType.fromString(reader.getString());
                    continue;
                }
                if ("kubernetesVersion".equals(fieldName)) {
                    deserializedManagedClusterUpgradeSpec.kubernetesVersion = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedClusterUpgradeSpec;
        });
    }
}

