/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservicefleet.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservicefleet.models.AgentProfile;
import com.azure.resourcemanager.containerservicefleet.models.ApiServerAccessProfile;
import java.io.IOException;

public final class FleetHubProfile
implements JsonSerializable<FleetHubProfile> {
    private String dnsPrefix;
    private ApiServerAccessProfile apiServerAccessProfile;
    private AgentProfile agentProfile;
    private String fqdn;
    private String kubernetesVersion;
    private String portalFqdn;

    public String dnsPrefix() {
        return this.dnsPrefix;
    }

    public FleetHubProfile withDnsPrefix(String dnsPrefix) {
        this.dnsPrefix = dnsPrefix;
        return this;
    }

    public ApiServerAccessProfile apiServerAccessProfile() {
        return this.apiServerAccessProfile;
    }

    public FleetHubProfile withApiServerAccessProfile(ApiServerAccessProfile apiServerAccessProfile) {
        this.apiServerAccessProfile = apiServerAccessProfile;
        return this;
    }

    public AgentProfile agentProfile() {
        return this.agentProfile;
    }

    public FleetHubProfile withAgentProfile(AgentProfile agentProfile) {
        this.agentProfile = agentProfile;
        return this;
    }

    public String fqdn() {
        return this.fqdn;
    }

    public String kubernetesVersion() {
        return this.kubernetesVersion;
    }

    public String portalFqdn() {
        return this.portalFqdn;
    }

    public void validate() {
        if (this.apiServerAccessProfile() != null) {
            this.apiServerAccessProfile().validate();
        }
        if (this.agentProfile() != null) {
            this.agentProfile().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("dnsPrefix", this.dnsPrefix);
        jsonWriter.writeJsonField("apiServerAccessProfile", (JsonSerializable)this.apiServerAccessProfile);
        jsonWriter.writeJsonField("agentProfile", (JsonSerializable)this.agentProfile);
        return jsonWriter.writeEndObject();
    }

    public static FleetHubProfile fromJson(JsonReader jsonReader) throws IOException {
        return (FleetHubProfile)jsonReader.readObject(reader -> {
            FleetHubProfile deserializedFleetHubProfile = new FleetHubProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dnsPrefix".equals(fieldName)) {
                    deserializedFleetHubProfile.dnsPrefix = reader.getString();
                    continue;
                }
                if ("apiServerAccessProfile".equals(fieldName)) {
                    deserializedFleetHubProfile.apiServerAccessProfile = ApiServerAccessProfile.fromJson(reader);
                    continue;
                }
                if ("agentProfile".equals(fieldName)) {
                    deserializedFleetHubProfile.agentProfile = AgentProfile.fromJson(reader);
                    continue;
                }
                if ("fqdn".equals(fieldName)) {
                    deserializedFleetHubProfile.fqdn = reader.getString();
                    continue;
                }
                if ("kubernetesVersion".equals(fieldName)) {
                    deserializedFleetHubProfile.kubernetesVersion = reader.getString();
                    continue;
                }
                if ("portalFqdn".equals(fieldName)) {
                    deserializedFleetHubProfile.portalFqdn = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFleetHubProfile;
        });
    }
}

