/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservicefleet.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.containerservicefleet.fluent.models.FleetInner;
import com.azure.resourcemanager.containerservicefleet.models.FleetCredentialResults;
import com.azure.resourcemanager.containerservicefleet.models.FleetHubProfile;
import com.azure.resourcemanager.containerservicefleet.models.FleetProvisioningState;
import com.azure.resourcemanager.containerservicefleet.models.FleetStatus;
import com.azure.resourcemanager.containerservicefleet.models.ManagedServiceIdentity;
import java.util.Map;

public interface Fleet {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public String etag();

    public ManagedServiceIdentity identity();

    public SystemData systemData();

    public FleetProvisioningState provisioningState();

    public FleetHubProfile hubProfile();

    public FleetStatus status();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public FleetInner innerModel();

    public Update update();

    public Fleet refresh();

    public Fleet refresh(Context var1);

    public Response<FleetCredentialResults> listCredentialsWithResponse(Context var1);

    public FleetCredentialResults listCredentials();

    public static interface UpdateStages {

        public static interface WithIfMatch {
            public Update withIfMatch(String var1);
        }

        public static interface WithIdentity {
            public Update withIdentity(ManagedServiceIdentity var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithIdentity,
    UpdateStages.WithIfMatch {
        public Fleet apply();

        public Fleet apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIfNoneMatch {
            public WithCreate withIfNoneMatch(String var1);
        }

        public static interface WithIfMatch {
            public WithCreate withIfMatch(String var1);
        }

        public static interface WithHubProfile {
            public WithCreate withHubProfile(FleetHubProfile var1);
        }

        public static interface WithIdentity {
            public WithCreate withIdentity(ManagedServiceIdentity var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithIdentity,
        WithHubProfile,
        WithIfMatch,
        WithIfNoneMatch {
            public Fleet create();

            public Fleet create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

