/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservicefleet.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerservicefleet.ContainerServiceFleetManager;
import com.azure.resourcemanager.containerservicefleet.fluent.FleetUpdateStrategiesClient;
import com.azure.resourcemanager.containerservicefleet.fluent.models.FleetUpdateStrategyInner;
import com.azure.resourcemanager.containerservicefleet.implementation.FleetUpdateStrategyImpl;
import com.azure.resourcemanager.containerservicefleet.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.containerservicefleet.models.FleetUpdateStrategies;
import com.azure.resourcemanager.containerservicefleet.models.FleetUpdateStrategy;

public final class FleetUpdateStrategiesImpl
implements FleetUpdateStrategies {
    private static final ClientLogger LOGGER = new ClientLogger(FleetUpdateStrategiesImpl.class);
    private final FleetUpdateStrategiesClient innerClient;
    private final ContainerServiceFleetManager serviceManager;

    public FleetUpdateStrategiesImpl(FleetUpdateStrategiesClient innerClient, ContainerServiceFleetManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<FleetUpdateStrategy> getWithResponse(String resourceGroupName, String fleetName, String updateStrategyName, Context context) {
        Response<FleetUpdateStrategyInner> inner = this.serviceClient().getWithResponse(resourceGroupName, fleetName, updateStrategyName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new FleetUpdateStrategyImpl((FleetUpdateStrategyInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public FleetUpdateStrategy get(String resourceGroupName, String fleetName, String updateStrategyName) {
        FleetUpdateStrategyInner inner = this.serviceClient().get(resourceGroupName, fleetName, updateStrategyName);
        if (inner != null) {
            return new FleetUpdateStrategyImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String fleetName, String updateStrategyName) {
        this.serviceClient().delete(resourceGroupName, fleetName, updateStrategyName);
    }

    @Override
    public void delete(String resourceGroupName, String fleetName, String updateStrategyName, String ifMatch, Context context) {
        this.serviceClient().delete(resourceGroupName, fleetName, updateStrategyName, ifMatch, context);
    }

    @Override
    public PagedIterable<FleetUpdateStrategy> listByFleet(String resourceGroupName, String fleetName) {
        PagedIterable<FleetUpdateStrategyInner> inner = this.serviceClient().listByFleet(resourceGroupName, fleetName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new FleetUpdateStrategyImpl((FleetUpdateStrategyInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<FleetUpdateStrategy> listByFleet(String resourceGroupName, String fleetName, Context context) {
        PagedIterable<FleetUpdateStrategyInner> inner = this.serviceClient().listByFleet(resourceGroupName, fleetName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new FleetUpdateStrategyImpl((FleetUpdateStrategyInner)((Object)inner1), this.manager()));
    }

    @Override
    public FleetUpdateStrategy getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String fleetName = ResourceManagerUtils.getValueFromIdByName(id, "fleets");
        if (fleetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'fleets'.", id)));
        }
        String updateStrategyName = ResourceManagerUtils.getValueFromIdByName(id, "updateStrategies");
        if (updateStrategyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'updateStrategies'.", id)));
        }
        return (FleetUpdateStrategy)this.getWithResponse(resourceGroupName, fleetName, updateStrategyName, Context.NONE).getValue();
    }

    @Override
    public Response<FleetUpdateStrategy> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String fleetName = ResourceManagerUtils.getValueFromIdByName(id, "fleets");
        if (fleetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'fleets'.", id)));
        }
        String updateStrategyName = ResourceManagerUtils.getValueFromIdByName(id, "updateStrategies");
        if (updateStrategyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'updateStrategies'.", id)));
        }
        return this.getWithResponse(resourceGroupName, fleetName, updateStrategyName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String fleetName = ResourceManagerUtils.getValueFromIdByName(id, "fleets");
        if (fleetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'fleets'.", id)));
        }
        String updateStrategyName = ResourceManagerUtils.getValueFromIdByName(id, "updateStrategies");
        if (updateStrategyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'updateStrategies'.", id)));
        }
        String localIfMatch = null;
        this.delete(resourceGroupName, fleetName, updateStrategyName, localIfMatch, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String fleetName = ResourceManagerUtils.getValueFromIdByName(id, "fleets");
        if (fleetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'fleets'.", id)));
        }
        String updateStrategyName = ResourceManagerUtils.getValueFromIdByName(id, "updateStrategies");
        if (updateStrategyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'updateStrategies'.", id)));
        }
        this.delete(resourceGroupName, fleetName, updateStrategyName, ifMatch, context);
    }

    private FleetUpdateStrategiesClient serviceClient() {
        return this.innerClient;
    }

    private ContainerServiceFleetManager manager() {
        return this.serviceManager;
    }

    @Override
    public FleetUpdateStrategyImpl define(String name) {
        return new FleetUpdateStrategyImpl(name, this.manager());
    }
}

