/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservicefleet.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerservicefleet.ContainerServiceFleetManager;
import com.azure.resourcemanager.containerservicefleet.fluent.FleetMembersClient;
import com.azure.resourcemanager.containerservicefleet.fluent.models.FleetMemberInner;
import com.azure.resourcemanager.containerservicefleet.implementation.FleetMemberImpl;
import com.azure.resourcemanager.containerservicefleet.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.containerservicefleet.models.FleetMember;
import com.azure.resourcemanager.containerservicefleet.models.FleetMembers;

public final class FleetMembersImpl
implements FleetMembers {
    private static final ClientLogger LOGGER = new ClientLogger(FleetMembersImpl.class);
    private final FleetMembersClient innerClient;
    private final ContainerServiceFleetManager serviceManager;

    public FleetMembersImpl(FleetMembersClient innerClient, ContainerServiceFleetManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<FleetMember> getWithResponse(String resourceGroupName, String fleetName, String fleetMemberName, Context context) {
        Response<FleetMemberInner> inner = this.serviceClient().getWithResponse(resourceGroupName, fleetName, fleetMemberName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new FleetMemberImpl((FleetMemberInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public FleetMember get(String resourceGroupName, String fleetName, String fleetMemberName) {
        FleetMemberInner inner = this.serviceClient().get(resourceGroupName, fleetName, fleetMemberName);
        if (inner != null) {
            return new FleetMemberImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String fleetName, String fleetMemberName) {
        this.serviceClient().delete(resourceGroupName, fleetName, fleetMemberName);
    }

    @Override
    public void delete(String resourceGroupName, String fleetName, String fleetMemberName, String ifMatch, Context context) {
        this.serviceClient().delete(resourceGroupName, fleetName, fleetMemberName, ifMatch, context);
    }

    @Override
    public PagedIterable<FleetMember> listByFleet(String resourceGroupName, String fleetName) {
        PagedIterable<FleetMemberInner> inner = this.serviceClient().listByFleet(resourceGroupName, fleetName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new FleetMemberImpl((FleetMemberInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<FleetMember> listByFleet(String resourceGroupName, String fleetName, Context context) {
        PagedIterable<FleetMemberInner> inner = this.serviceClient().listByFleet(resourceGroupName, fleetName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new FleetMemberImpl((FleetMemberInner)((Object)inner1), this.manager()));
    }

    @Override
    public FleetMember getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String fleetName = ResourceManagerUtils.getValueFromIdByName(id, "fleets");
        if (fleetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'fleets'.", id)));
        }
        String fleetMemberName = ResourceManagerUtils.getValueFromIdByName(id, "members");
        if (fleetMemberName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'members'.", id)));
        }
        return (FleetMember)this.getWithResponse(resourceGroupName, fleetName, fleetMemberName, Context.NONE).getValue();
    }

    @Override
    public Response<FleetMember> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String fleetName = ResourceManagerUtils.getValueFromIdByName(id, "fleets");
        if (fleetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'fleets'.", id)));
        }
        String fleetMemberName = ResourceManagerUtils.getValueFromIdByName(id, "members");
        if (fleetMemberName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'members'.", id)));
        }
        return this.getWithResponse(resourceGroupName, fleetName, fleetMemberName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String fleetName = ResourceManagerUtils.getValueFromIdByName(id, "fleets");
        if (fleetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'fleets'.", id)));
        }
        String fleetMemberName = ResourceManagerUtils.getValueFromIdByName(id, "members");
        if (fleetMemberName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'members'.", id)));
        }
        String localIfMatch = null;
        this.delete(resourceGroupName, fleetName, fleetMemberName, localIfMatch, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String fleetName = ResourceManagerUtils.getValueFromIdByName(id, "fleets");
        if (fleetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'fleets'.", id)));
        }
        String fleetMemberName = ResourceManagerUtils.getValueFromIdByName(id, "members");
        if (fleetMemberName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'members'.", id)));
        }
        this.delete(resourceGroupName, fleetName, fleetMemberName, ifMatch, context);
    }

    private FleetMembersClient serviceClient() {
        return this.innerClient;
    }

    private ContainerServiceFleetManager manager() {
        return this.serviceManager;
    }

    @Override
    public FleetMemberImpl define(String name) {
        return new FleetMemberImpl(name, this.manager());
    }
}

