/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservicefleet.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.containerservicefleet.ContainerServiceFleetManager;
import com.azure.resourcemanager.containerservicefleet.fluent.models.FleetMemberInner;
import com.azure.resourcemanager.containerservicefleet.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.containerservicefleet.models.FleetMember;
import com.azure.resourcemanager.containerservicefleet.models.FleetMemberProvisioningState;
import com.azure.resourcemanager.containerservicefleet.models.FleetMemberStatus;
import com.azure.resourcemanager.containerservicefleet.models.FleetMemberUpdate;

public final class FleetMemberImpl
implements FleetMember,
FleetMember.Definition,
FleetMember.Update {
    private FleetMemberInner innerObject;
    private final ContainerServiceFleetManager serviceManager;
    private String resourceGroupName;
    private String fleetName;
    private String fleetMemberName;
    private String createIfMatch;
    private String createIfNoneMatch;
    private String updateIfMatch;
    private FleetMemberUpdate updateProperties;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String clusterResourceId() {
        return this.innerModel().clusterResourceId();
    }

    @Override
    public String group() {
        return this.innerModel().group();
    }

    @Override
    public FleetMemberProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public FleetMemberStatus status() {
        return this.innerModel().status();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public FleetMemberInner innerModel() {
        return this.innerObject;
    }

    private ContainerServiceFleetManager manager() {
        return this.serviceManager;
    }

    @Override
    public FleetMemberImpl withExistingFleet(String resourceGroupName, String fleetName) {
        this.resourceGroupName = resourceGroupName;
        this.fleetName = fleetName;
        return this;
    }

    @Override
    public FleetMember create() {
        this.innerObject = this.serviceManager.serviceClient().getFleetMembers().create(this.resourceGroupName, this.fleetName, this.fleetMemberName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, Context.NONE);
        return this;
    }

    @Override
    public FleetMember create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getFleetMembers().create(this.resourceGroupName, this.fleetName, this.fleetMemberName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, context);
        return this;
    }

    FleetMemberImpl(String name, ContainerServiceFleetManager serviceManager) {
        this.innerObject = new FleetMemberInner();
        this.serviceManager = serviceManager;
        this.fleetMemberName = name;
        this.createIfMatch = null;
        this.createIfNoneMatch = null;
    }

    @Override
    public FleetMemberImpl update() {
        this.updateIfMatch = null;
        this.updateProperties = new FleetMemberUpdate();
        return this;
    }

    @Override
    public FleetMember apply() {
        this.innerObject = this.serviceManager.serviceClient().getFleetMembers().updateAsync(this.resourceGroupName, this.fleetName, this.fleetMemberName, this.updateProperties, this.updateIfMatch, Context.NONE);
        return this;
    }

    @Override
    public FleetMember apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getFleetMembers().updateAsync(this.resourceGroupName, this.fleetName, this.fleetMemberName, this.updateProperties, this.updateIfMatch, context);
        return this;
    }

    FleetMemberImpl(FleetMemberInner innerObject, ContainerServiceFleetManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.fleetName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "fleets");
        this.fleetMemberName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "members");
    }

    @Override
    public FleetMember refresh() {
        this.innerObject = (FleetMemberInner)((Object)this.serviceManager.serviceClient().getFleetMembers().getWithResponse(this.resourceGroupName, this.fleetName, this.fleetMemberName, Context.NONE).getValue());
        return this;
    }

    @Override
    public FleetMember refresh(Context context) {
        this.innerObject = (FleetMemberInner)((Object)this.serviceManager.serviceClient().getFleetMembers().getWithResponse(this.resourceGroupName, this.fleetName, this.fleetMemberName, context).getValue());
        return this;
    }

    @Override
    public FleetMemberImpl withClusterResourceId(String clusterResourceId) {
        this.innerModel().withClusterResourceId(clusterResourceId);
        return this;
    }

    @Override
    public FleetMemberImpl withGroup(String group) {
        if (this.isInCreateMode()) {
            this.innerModel().withGroup(group);
            return this;
        }
        this.updateProperties.withGroup(group);
        return this;
    }

    @Override
    public FleetMemberImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    @Override
    public FleetMemberImpl withIfNoneMatch(String ifNoneMatch) {
        this.createIfNoneMatch = ifNoneMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

