/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservicefleet.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.containerservicefleet.ContainerServiceFleetManager;
import com.azure.resourcemanager.containerservicefleet.fluent.models.FleetInner;
import com.azure.resourcemanager.containerservicefleet.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.containerservicefleet.models.Fleet;
import com.azure.resourcemanager.containerservicefleet.models.FleetCredentialResults;
import com.azure.resourcemanager.containerservicefleet.models.FleetHubProfile;
import com.azure.resourcemanager.containerservicefleet.models.FleetPatch;
import com.azure.resourcemanager.containerservicefleet.models.FleetProvisioningState;
import com.azure.resourcemanager.containerservicefleet.models.FleetStatus;
import com.azure.resourcemanager.containerservicefleet.models.ManagedServiceIdentity;
import java.util.Collections;
import java.util.Map;

public final class FleetImpl
implements Fleet,
Fleet.Definition,
Fleet.Update {
    private FleetInner innerObject;
    private final ContainerServiceFleetManager serviceManager;
    private String resourceGroupName;
    private String fleetName;
    private String createIfMatch;
    private String createIfNoneMatch;
    private String updateIfMatch;
    private FleetPatch updateProperties;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public ManagedServiceIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public FleetProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public FleetHubProfile hubProfile() {
        return this.innerModel().hubProfile();
    }

    @Override
    public FleetStatus status() {
        return this.innerModel().status();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public FleetInner innerModel() {
        return this.innerObject;
    }

    private ContainerServiceFleetManager manager() {
        return this.serviceManager;
    }

    @Override
    public FleetImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Fleet create() {
        this.innerObject = this.serviceManager.serviceClient().getFleets().create(this.resourceGroupName, this.fleetName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, Context.NONE);
        return this;
    }

    @Override
    public Fleet create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getFleets().create(this.resourceGroupName, this.fleetName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, context);
        return this;
    }

    FleetImpl(String name, ContainerServiceFleetManager serviceManager) {
        this.innerObject = new FleetInner();
        this.serviceManager = serviceManager;
        this.fleetName = name;
        this.createIfMatch = null;
        this.createIfNoneMatch = null;
    }

    @Override
    public FleetImpl update() {
        this.updateIfMatch = null;
        this.updateProperties = new FleetPatch();
        return this;
    }

    @Override
    public Fleet apply() {
        this.innerObject = this.serviceManager.serviceClient().getFleets().updateAsync(this.resourceGroupName, this.fleetName, this.updateProperties, this.updateIfMatch, Context.NONE);
        return this;
    }

    @Override
    public Fleet apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getFleets().updateAsync(this.resourceGroupName, this.fleetName, this.updateProperties, this.updateIfMatch, context);
        return this;
    }

    FleetImpl(FleetInner innerObject, ContainerServiceFleetManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.fleetName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "fleets");
    }

    @Override
    public Fleet refresh() {
        this.innerObject = (FleetInner)((Object)this.serviceManager.serviceClient().getFleets().getByResourceGroupWithResponse(this.resourceGroupName, this.fleetName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Fleet refresh(Context context) {
        this.innerObject = (FleetInner)((Object)this.serviceManager.serviceClient().getFleets().getByResourceGroupWithResponse(this.resourceGroupName, this.fleetName, context).getValue());
        return this;
    }

    @Override
    public Response<FleetCredentialResults> listCredentialsWithResponse(Context context) {
        return this.serviceManager.fleets().listCredentialsWithResponse(this.resourceGroupName, this.fleetName, context);
    }

    @Override
    public FleetCredentialResults listCredentials() {
        return this.serviceManager.fleets().listCredentials(this.resourceGroupName, this.fleetName);
    }

    @Override
    public FleetImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public FleetImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public FleetImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateProperties.withTags(tags);
        return this;
    }

    @Override
    public FleetImpl withIdentity(ManagedServiceIdentity identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updateProperties.withIdentity(identity);
        return this;
    }

    @Override
    public FleetImpl withHubProfile(FleetHubProfile hubProfile) {
        this.innerModel().withHubProfile(hubProfile);
        return this;
    }

    @Override
    public FleetImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    @Override
    public FleetImpl withIfNoneMatch(String ifNoneMatch) {
        this.createIfNoneMatch = ifNoneMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

