/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservicefleet.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.management.polling.SyncPollerFactory;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.containerservicefleet.fluent.AutoUpgradeProfileOperationsClient;
import com.azure.resourcemanager.containerservicefleet.fluent.AutoUpgradeProfilesClient;
import com.azure.resourcemanager.containerservicefleet.fluent.ContainerServiceFleetManagementClient;
import com.azure.resourcemanager.containerservicefleet.fluent.FleetMembersClient;
import com.azure.resourcemanager.containerservicefleet.fluent.FleetUpdateStrategiesClient;
import com.azure.resourcemanager.containerservicefleet.fluent.FleetsClient;
import com.azure.resourcemanager.containerservicefleet.fluent.OperationsClient;
import com.azure.resourcemanager.containerservicefleet.fluent.UpdateRunsClient;
import com.azure.resourcemanager.containerservicefleet.implementation.AutoUpgradeProfileOperationsClientImpl;
import com.azure.resourcemanager.containerservicefleet.implementation.AutoUpgradeProfilesClientImpl;
import com.azure.resourcemanager.containerservicefleet.implementation.ContainerServiceFleetManagementClientBuilder;
import com.azure.resourcemanager.containerservicefleet.implementation.FleetMembersClientImpl;
import com.azure.resourcemanager.containerservicefleet.implementation.FleetUpdateStrategiesClientImpl;
import com.azure.resourcemanager.containerservicefleet.implementation.FleetsClientImpl;
import com.azure.resourcemanager.containerservicefleet.implementation.OperationsClientImpl;
import com.azure.resourcemanager.containerservicefleet.implementation.UpdateRunsClientImpl;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ContainerServiceFleetManagementClientBuilder.class)
public final class ContainerServiceFleetManagementClientImpl
implements ContainerServiceFleetManagementClient {
    private final String endpoint;
    private final String apiVersion;
    private final String subscriptionId;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final OperationsClient operations;
    private final FleetsClient fleets;
    private final FleetMembersClient fleetMembers;
    private final UpdateRunsClient updateRuns;
    private final FleetUpdateStrategiesClient fleetUpdateStrategies;
    private final AutoUpgradeProfilesClient autoUpgradeProfiles;
    private final AutoUpgradeProfileOperationsClient autoUpgradeProfileOperations;
    private static final ClientLogger LOGGER = new ClientLogger(ContainerServiceFleetManagementClientImpl.class);

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public FleetsClient getFleets() {
        return this.fleets;
    }

    @Override
    public FleetMembersClient getFleetMembers() {
        return this.fleetMembers;
    }

    @Override
    public UpdateRunsClient getUpdateRuns() {
        return this.updateRuns;
    }

    @Override
    public FleetUpdateStrategiesClient getFleetUpdateStrategies() {
        return this.fleetUpdateStrategies;
    }

    @Override
    public AutoUpgradeProfilesClient getAutoUpgradeProfiles() {
        return this.autoUpgradeProfiles;
    }

    @Override
    public AutoUpgradeProfileOperationsClient getAutoUpgradeProfileOperations() {
        return this.autoUpgradeProfileOperations;
    }

    ContainerServiceFleetManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String endpoint, String subscriptionId) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.endpoint = endpoint;
        this.subscriptionId = subscriptionId;
        this.apiVersion = "2025-03-01";
        this.operations = new OperationsClientImpl(this);
        this.fleets = new FleetsClientImpl(this);
        this.fleetMembers = new FleetMembersClientImpl(this);
        this.updateRuns = new UpdateRunsClientImpl(this);
        this.fleetUpdateStrategies = new FleetUpdateStrategiesClientImpl(this);
        this.autoUpgradeProfiles = new AutoUpgradeProfilesClientImpl(this);
        this.autoUpgradeProfileOperations = new AutoUpgradeProfileOperationsClientImpl(this);
    }

    public Context getContext() {
        return Context.NONE;
    }

    public Context mergeContext(Context context) {
        return CoreUtils.mergeContexts((Context)this.getContext(), (Context)context);
    }

    public <T, U> PollerFlux<PollResult<T>, U> getLroResult(Mono<Response<Flux<ByteBuffer>>> activationResponse, HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Context context) {
        return PollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, activationResponse, (Context)context);
    }

    public <T, U> SyncPoller<PollResult<T>, U> getLroResult(Response<BinaryData> activationResponse, Type pollResultType, Type finalResultType, Context context) {
        return SyncPollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)this.httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, () -> activationResponse, (Context)context);
    }

    public <T, U> Mono<U> getLroFinalResultOrError(AsyncPollResponse<PollResult<T>, U> response) {
        if (response.getStatus() != LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String errorMessage;
            ManagementError managementError = null;
            HttpResponseImpl errorResponse = null;
            PollResult.Error lroError = ((PollResult)response.getValue()).getError();
            if (lroError != null) {
                errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(), lroError.getResponseBody());
                errorMessage = ((PollResult)response.getValue()).getError().getMessage();
                String errorBody = ((PollResult)response.getValue()).getError().getResponseBody();
                if (errorBody != null) {
                    try {
                        managementError = (ManagementError)this.getSerializerAdapter().deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                        if (managementError.getCode() == null || managementError.getMessage() == null) {
                            managementError = null;
                        }
                    }
                    catch (IOException | RuntimeException ioe) {
                        LOGGER.logThrowableAsWarning((Throwable)ioe);
                    }
                }
            } else {
                errorMessage = "Long running operation failed.";
            }
            if (managementError == null) {
                managementError = new ManagementError(response.getStatus().toString(), errorMessage);
            }
            return Mono.error((Throwable)new ManagementException(errorMessage, (HttpResponse)errorResponse, managementError));
        }
        return response.getFinalResult();
    }

    private static final class HttpResponseImpl
    extends HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String s) {
            return this.httpHeaders.getValue(HttpHeaderName.fromString((String)s));
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just((Object)ByteBuffer.wrap(this.responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just((Object)this.responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just((Object)new String(this.responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just((Object)new String(this.responseBody, charset));
        }
    }
}

