/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservicefleet.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.containerservicefleet.ContainerServiceFleetManager;
import com.azure.resourcemanager.containerservicefleet.fluent.models.AutoUpgradeProfileInner;
import com.azure.resourcemanager.containerservicefleet.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.containerservicefleet.models.AutoUpgradeNodeImageSelection;
import com.azure.resourcemanager.containerservicefleet.models.AutoUpgradeProfile;
import com.azure.resourcemanager.containerservicefleet.models.AutoUpgradeProfileProvisioningState;
import com.azure.resourcemanager.containerservicefleet.models.AutoUpgradeProfileStatus;
import com.azure.resourcemanager.containerservicefleet.models.UpgradeChannel;

public final class AutoUpgradeProfileImpl
implements AutoUpgradeProfile,
AutoUpgradeProfile.Definition,
AutoUpgradeProfile.Update {
    private AutoUpgradeProfileInner innerObject;
    private final ContainerServiceFleetManager serviceManager;
    private String resourceGroupName;
    private String fleetName;
    private String autoUpgradeProfileName;
    private String createIfMatch;
    private String createIfNoneMatch;
    private String updateIfMatch;
    private String updateIfNoneMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public AutoUpgradeProfileProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String updateStrategyId() {
        return this.innerModel().updateStrategyId();
    }

    @Override
    public UpgradeChannel channel() {
        return this.innerModel().channel();
    }

    @Override
    public AutoUpgradeNodeImageSelection nodeImageSelection() {
        return this.innerModel().nodeImageSelection();
    }

    @Override
    public Boolean disabled() {
        return this.innerModel().disabled();
    }

    @Override
    public AutoUpgradeProfileStatus autoUpgradeProfileStatus() {
        return this.innerModel().autoUpgradeProfileStatus();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public AutoUpgradeProfileInner innerModel() {
        return this.innerObject;
    }

    private ContainerServiceFleetManager manager() {
        return this.serviceManager;
    }

    @Override
    public AutoUpgradeProfileImpl withExistingFleet(String resourceGroupName, String fleetName) {
        this.resourceGroupName = resourceGroupName;
        this.fleetName = fleetName;
        return this;
    }

    @Override
    public AutoUpgradeProfile create() {
        this.innerObject = this.serviceManager.serviceClient().getAutoUpgradeProfiles().createOrUpdate(this.resourceGroupName, this.fleetName, this.autoUpgradeProfileName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, Context.NONE);
        return this;
    }

    @Override
    public AutoUpgradeProfile create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAutoUpgradeProfiles().createOrUpdate(this.resourceGroupName, this.fleetName, this.autoUpgradeProfileName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, context);
        return this;
    }

    AutoUpgradeProfileImpl(String name, ContainerServiceFleetManager serviceManager) {
        this.innerObject = new AutoUpgradeProfileInner();
        this.serviceManager = serviceManager;
        this.autoUpgradeProfileName = name;
        this.createIfMatch = null;
        this.createIfNoneMatch = null;
    }

    @Override
    public AutoUpgradeProfileImpl update() {
        this.updateIfMatch = null;
        this.updateIfNoneMatch = null;
        return this;
    }

    @Override
    public AutoUpgradeProfile apply() {
        this.innerObject = this.serviceManager.serviceClient().getAutoUpgradeProfiles().createOrUpdate(this.resourceGroupName, this.fleetName, this.autoUpgradeProfileName, this.innerModel(), this.updateIfMatch, this.updateIfNoneMatch, Context.NONE);
        return this;
    }

    @Override
    public AutoUpgradeProfile apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAutoUpgradeProfiles().createOrUpdate(this.resourceGroupName, this.fleetName, this.autoUpgradeProfileName, this.innerModel(), this.updateIfMatch, this.updateIfNoneMatch, context);
        return this;
    }

    AutoUpgradeProfileImpl(AutoUpgradeProfileInner innerObject, ContainerServiceFleetManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.fleetName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "fleets");
        this.autoUpgradeProfileName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "autoUpgradeProfiles");
    }

    @Override
    public AutoUpgradeProfile refresh() {
        this.innerObject = (AutoUpgradeProfileInner)((Object)this.serviceManager.serviceClient().getAutoUpgradeProfiles().getWithResponse(this.resourceGroupName, this.fleetName, this.autoUpgradeProfileName, Context.NONE).getValue());
        return this;
    }

    @Override
    public AutoUpgradeProfile refresh(Context context) {
        this.innerObject = (AutoUpgradeProfileInner)((Object)this.serviceManager.serviceClient().getAutoUpgradeProfiles().getWithResponse(this.resourceGroupName, this.fleetName, this.autoUpgradeProfileName, context).getValue());
        return this;
    }

    @Override
    public AutoUpgradeProfileImpl withUpdateStrategyId(String updateStrategyId) {
        this.innerModel().withUpdateStrategyId(updateStrategyId);
        return this;
    }

    @Override
    public AutoUpgradeProfileImpl withChannel(UpgradeChannel channel) {
        this.innerModel().withChannel(channel);
        return this;
    }

    @Override
    public AutoUpgradeProfileImpl withNodeImageSelection(AutoUpgradeNodeImageSelection nodeImageSelection) {
        this.innerModel().withNodeImageSelection(nodeImageSelection);
        return this;
    }

    @Override
    public AutoUpgradeProfileImpl withDisabled(Boolean disabled) {
        this.innerModel().withDisabled(disabled);
        return this;
    }

    @Override
    public AutoUpgradeProfileImpl withAutoUpgradeProfileStatus(AutoUpgradeProfileStatus autoUpgradeProfileStatus) {
        this.innerModel().withAutoUpgradeProfileStatus(autoUpgradeProfileStatus);
        return this;
    }

    @Override
    public AutoUpgradeProfileImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    @Override
    public AutoUpgradeProfileImpl withIfNoneMatch(String ifNoneMatch) {
        if (this.isInCreateMode()) {
            this.createIfNoneMatch = ifNoneMatch;
            return this;
        }
        this.updateIfNoneMatch = ifNoneMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

