/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservicefleet.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservicefleet.models.ManagedClusterUpdate;
import com.azure.resourcemanager.containerservicefleet.models.UpdateRunProvisioningState;
import com.azure.resourcemanager.containerservicefleet.models.UpdateRunStatus;
import com.azure.resourcemanager.containerservicefleet.models.UpdateRunStrategy;
import java.io.IOException;

public final class UpdateRunProperties
implements JsonSerializable<UpdateRunProperties> {
    private UpdateRunProvisioningState provisioningState;
    private String updateStrategyId;
    private UpdateRunStrategy strategy;
    private ManagedClusterUpdate managedClusterUpdate;
    private UpdateRunStatus status;
    private String autoUpgradeProfileId;
    private static final ClientLogger LOGGER = new ClientLogger(UpdateRunProperties.class);

    public UpdateRunProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String updateStrategyId() {
        return this.updateStrategyId;
    }

    public UpdateRunProperties withUpdateStrategyId(String updateStrategyId) {
        this.updateStrategyId = updateStrategyId;
        return this;
    }

    public UpdateRunStrategy strategy() {
        return this.strategy;
    }

    public UpdateRunProperties withStrategy(UpdateRunStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public ManagedClusterUpdate managedClusterUpdate() {
        return this.managedClusterUpdate;
    }

    public UpdateRunProperties withManagedClusterUpdate(ManagedClusterUpdate managedClusterUpdate) {
        this.managedClusterUpdate = managedClusterUpdate;
        return this;
    }

    public UpdateRunStatus status() {
        return this.status;
    }

    public String autoUpgradeProfileId() {
        return this.autoUpgradeProfileId;
    }

    public void validate() {
        if (this.strategy() != null) {
            this.strategy().validate();
        }
        if (this.managedClusterUpdate() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property managedClusterUpdate in model UpdateRunProperties"));
        }
        this.managedClusterUpdate().validate();
        if (this.status() != null) {
            this.status().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("managedClusterUpdate", (JsonSerializable)this.managedClusterUpdate);
        jsonWriter.writeStringField("updateStrategyId", this.updateStrategyId);
        jsonWriter.writeJsonField("strategy", (JsonSerializable)this.strategy);
        return jsonWriter.writeEndObject();
    }

    public static UpdateRunProperties fromJson(JsonReader jsonReader) throws IOException {
        return (UpdateRunProperties)jsonReader.readObject(reader -> {
            UpdateRunProperties deserializedUpdateRunProperties = new UpdateRunProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("managedClusterUpdate".equals(fieldName)) {
                    deserializedUpdateRunProperties.managedClusterUpdate = ManagedClusterUpdate.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedUpdateRunProperties.provisioningState = UpdateRunProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("updateStrategyId".equals(fieldName)) {
                    deserializedUpdateRunProperties.updateStrategyId = reader.getString();
                    continue;
                }
                if ("strategy".equals(fieldName)) {
                    deserializedUpdateRunProperties.strategy = UpdateRunStrategy.fromJson(reader);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedUpdateRunProperties.status = UpdateRunStatus.fromJson(reader);
                    continue;
                }
                if ("autoUpgradeProfileId".equals(fieldName)) {
                    deserializedUpdateRunProperties.autoUpgradeProfileId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUpdateRunProperties;
        });
    }
}

