/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservicefleet.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservicefleet.models.FleetUpdateStrategyProvisioningState;
import com.azure.resourcemanager.containerservicefleet.models.UpdateRunStrategy;
import java.io.IOException;

public final class FleetUpdateStrategyProperties
implements JsonSerializable<FleetUpdateStrategyProperties> {
    private FleetUpdateStrategyProvisioningState provisioningState;
    private UpdateRunStrategy strategy;
    private static final ClientLogger LOGGER = new ClientLogger(FleetUpdateStrategyProperties.class);

    public FleetUpdateStrategyProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public UpdateRunStrategy strategy() {
        return this.strategy;
    }

    public FleetUpdateStrategyProperties withStrategy(UpdateRunStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public void validate() {
        if (this.strategy() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property strategy in model FleetUpdateStrategyProperties"));
        }
        this.strategy().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("strategy", (JsonSerializable)this.strategy);
        return jsonWriter.writeEndObject();
    }

    public static FleetUpdateStrategyProperties fromJson(JsonReader jsonReader) throws IOException {
        return (FleetUpdateStrategyProperties)jsonReader.readObject(reader -> {
            FleetUpdateStrategyProperties deserializedFleetUpdateStrategyProperties = new FleetUpdateStrategyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("strategy".equals(fieldName)) {
                    deserializedFleetUpdateStrategyProperties.strategy = UpdateRunStrategy.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedFleetUpdateStrategyProperties.provisioningState = FleetUpdateStrategyProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFleetUpdateStrategyProperties;
        });
    }
}

