/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservicefleet.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservicefleet.models.FleetMemberProvisioningState;
import com.azure.resourcemanager.containerservicefleet.models.FleetMemberStatus;
import java.io.IOException;

public final class FleetMemberProperties
implements JsonSerializable<FleetMemberProperties> {
    private String clusterResourceId;
    private String group;
    private FleetMemberProvisioningState provisioningState;
    private FleetMemberStatus status;
    private static final ClientLogger LOGGER = new ClientLogger(FleetMemberProperties.class);

    public String clusterResourceId() {
        return this.clusterResourceId;
    }

    public FleetMemberProperties withClusterResourceId(String clusterResourceId) {
        this.clusterResourceId = clusterResourceId;
        return this;
    }

    public String group() {
        return this.group;
    }

    public FleetMemberProperties withGroup(String group) {
        this.group = group;
        return this;
    }

    public FleetMemberProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public FleetMemberStatus status() {
        return this.status;
    }

    public void validate() {
        if (this.clusterResourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property clusterResourceId in model FleetMemberProperties"));
        }
        if (this.status() != null) {
            this.status().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("clusterResourceId", this.clusterResourceId);
        jsonWriter.writeStringField("group", this.group);
        return jsonWriter.writeEndObject();
    }

    public static FleetMemberProperties fromJson(JsonReader jsonReader) throws IOException {
        return (FleetMemberProperties)jsonReader.readObject(reader -> {
            FleetMemberProperties deserializedFleetMemberProperties = new FleetMemberProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("clusterResourceId".equals(fieldName)) {
                    deserializedFleetMemberProperties.clusterResourceId = reader.getString();
                    continue;
                }
                if ("group".equals(fieldName)) {
                    deserializedFleetMemberProperties.group = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedFleetMemberProperties.provisioningState = FleetMemberProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedFleetMemberProperties.status = FleetMemberStatus.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFleetMemberProperties;
        });
    }
}

