/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservicefleet.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservicefleet.models.AutoUpgradeNodeImageSelection;
import com.azure.resourcemanager.containerservicefleet.models.AutoUpgradeProfileProvisioningState;
import com.azure.resourcemanager.containerservicefleet.models.AutoUpgradeProfileStatus;
import com.azure.resourcemanager.containerservicefleet.models.UpgradeChannel;
import java.io.IOException;

public final class AutoUpgradeProfileProperties
implements JsonSerializable<AutoUpgradeProfileProperties> {
    private AutoUpgradeProfileProvisioningState provisioningState;
    private String updateStrategyId;
    private UpgradeChannel channel;
    private AutoUpgradeNodeImageSelection nodeImageSelection;
    private Boolean disabled;
    private AutoUpgradeProfileStatus autoUpgradeProfileStatus;
    private static final ClientLogger LOGGER = new ClientLogger(AutoUpgradeProfileProperties.class);

    public AutoUpgradeProfileProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String updateStrategyId() {
        return this.updateStrategyId;
    }

    public AutoUpgradeProfileProperties withUpdateStrategyId(String updateStrategyId) {
        this.updateStrategyId = updateStrategyId;
        return this;
    }

    public UpgradeChannel channel() {
        return this.channel;
    }

    public AutoUpgradeProfileProperties withChannel(UpgradeChannel channel) {
        this.channel = channel;
        return this;
    }

    public AutoUpgradeNodeImageSelection nodeImageSelection() {
        return this.nodeImageSelection;
    }

    public AutoUpgradeProfileProperties withNodeImageSelection(AutoUpgradeNodeImageSelection nodeImageSelection) {
        this.nodeImageSelection = nodeImageSelection;
        return this;
    }

    public Boolean disabled() {
        return this.disabled;
    }

    public AutoUpgradeProfileProperties withDisabled(Boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    public AutoUpgradeProfileStatus autoUpgradeProfileStatus() {
        return this.autoUpgradeProfileStatus;
    }

    public AutoUpgradeProfileProperties withAutoUpgradeProfileStatus(AutoUpgradeProfileStatus autoUpgradeProfileStatus) {
        this.autoUpgradeProfileStatus = autoUpgradeProfileStatus;
        return this;
    }

    public void validate() {
        if (this.channel() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property channel in model AutoUpgradeProfileProperties"));
        }
        if (this.nodeImageSelection() != null) {
            this.nodeImageSelection().validate();
        }
        if (this.autoUpgradeProfileStatus() != null) {
            this.autoUpgradeProfileStatus().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("channel", this.channel == null ? null : this.channel.toString());
        jsonWriter.writeStringField("updateStrategyId", this.updateStrategyId);
        jsonWriter.writeJsonField("nodeImageSelection", (JsonSerializable)this.nodeImageSelection);
        jsonWriter.writeBooleanField("disabled", this.disabled);
        jsonWriter.writeJsonField("autoUpgradeProfileStatus", (JsonSerializable)this.autoUpgradeProfileStatus);
        return jsonWriter.writeEndObject();
    }

    public static AutoUpgradeProfileProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AutoUpgradeProfileProperties)jsonReader.readObject(reader -> {
            AutoUpgradeProfileProperties deserializedAutoUpgradeProfileProperties = new AutoUpgradeProfileProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("channel".equals(fieldName)) {
                    deserializedAutoUpgradeProfileProperties.channel = UpgradeChannel.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedAutoUpgradeProfileProperties.provisioningState = AutoUpgradeProfileProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("updateStrategyId".equals(fieldName)) {
                    deserializedAutoUpgradeProfileProperties.updateStrategyId = reader.getString();
                    continue;
                }
                if ("nodeImageSelection".equals(fieldName)) {
                    deserializedAutoUpgradeProfileProperties.nodeImageSelection = AutoUpgradeNodeImageSelection.fromJson(reader);
                    continue;
                }
                if ("disabled".equals(fieldName)) {
                    deserializedAutoUpgradeProfileProperties.disabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("autoUpgradeProfileStatus".equals(fieldName)) {
                    deserializedAutoUpgradeProfileProperties.autoUpgradeProfileStatus = AutoUpgradeProfileStatus.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAutoUpgradeProfileProperties;
        });
    }
}

