/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservicefleet.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservicefleet.fluent.models.AutoUpgradeProfileProperties;
import com.azure.resourcemanager.containerservicefleet.models.AutoUpgradeNodeImageSelection;
import com.azure.resourcemanager.containerservicefleet.models.AutoUpgradeProfileProvisioningState;
import com.azure.resourcemanager.containerservicefleet.models.AutoUpgradeProfileStatus;
import com.azure.resourcemanager.containerservicefleet.models.UpgradeChannel;
import java.io.IOException;

public final class AutoUpgradeProfileInner
extends ProxyResource {
    private AutoUpgradeProfileProperties innerProperties;
    private String etag;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private AutoUpgradeProfileProperties innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public AutoUpgradeProfileProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String updateStrategyId() {
        return this.innerProperties() == null ? null : this.innerProperties().updateStrategyId();
    }

    public AutoUpgradeProfileInner withUpdateStrategyId(String updateStrategyId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutoUpgradeProfileProperties();
        }
        this.innerProperties().withUpdateStrategyId(updateStrategyId);
        return this;
    }

    public UpgradeChannel channel() {
        return this.innerProperties() == null ? null : this.innerProperties().channel();
    }

    public AutoUpgradeProfileInner withChannel(UpgradeChannel channel) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutoUpgradeProfileProperties();
        }
        this.innerProperties().withChannel(channel);
        return this;
    }

    public AutoUpgradeNodeImageSelection nodeImageSelection() {
        return this.innerProperties() == null ? null : this.innerProperties().nodeImageSelection();
    }

    public AutoUpgradeProfileInner withNodeImageSelection(AutoUpgradeNodeImageSelection nodeImageSelection) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutoUpgradeProfileProperties();
        }
        this.innerProperties().withNodeImageSelection(nodeImageSelection);
        return this;
    }

    public Boolean disabled() {
        return this.innerProperties() == null ? null : this.innerProperties().disabled();
    }

    public AutoUpgradeProfileInner withDisabled(Boolean disabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutoUpgradeProfileProperties();
        }
        this.innerProperties().withDisabled(disabled);
        return this;
    }

    public AutoUpgradeProfileStatus autoUpgradeProfileStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().autoUpgradeProfileStatus();
    }

    public AutoUpgradeProfileInner withAutoUpgradeProfileStatus(AutoUpgradeProfileStatus autoUpgradeProfileStatus) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutoUpgradeProfileProperties();
        }
        this.innerProperties().withAutoUpgradeProfileStatus(autoUpgradeProfileStatus);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static AutoUpgradeProfileInner fromJson(JsonReader jsonReader) throws IOException {
        return (AutoUpgradeProfileInner)((Object)jsonReader.readObject(reader -> {
            AutoUpgradeProfileInner deserializedAutoUpgradeProfileInner = new AutoUpgradeProfileInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAutoUpgradeProfileInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAutoUpgradeProfileInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAutoUpgradeProfileInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAutoUpgradeProfileInner.innerProperties = AutoUpgradeProfileProperties.fromJson(reader);
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedAutoUpgradeProfileInner.etag = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedAutoUpgradeProfileInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAutoUpgradeProfileInner;
        }));
    }
}

