/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.AdoptionPolicy;
import com.azure.resourcemanager.containerservice.models.DeletePolicy;
import com.azure.resourcemanager.containerservice.models.NamespaceProvisioningState;
import com.azure.resourcemanager.containerservice.models.NetworkPolicies;
import com.azure.resourcemanager.containerservice.models.ResourceQuota;
import java.io.IOException;
import java.util.Map;

public final class NamespaceProperties
implements JsonSerializable<NamespaceProperties> {
    private NamespaceProvisioningState provisioningState;
    private Map<String, String> labels;
    private Map<String, String> annotations;
    private String portalFqdn;
    private ResourceQuota defaultResourceQuota;
    private NetworkPolicies defaultNetworkPolicy;
    private AdoptionPolicy adoptionPolicy;
    private DeletePolicy deletePolicy;

    public NamespaceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Map<String, String> labels() {
        return this.labels;
    }

    public NamespaceProperties withLabels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public Map<String, String> annotations() {
        return this.annotations;
    }

    public NamespaceProperties withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
        return this;
    }

    public String portalFqdn() {
        return this.portalFqdn;
    }

    public ResourceQuota defaultResourceQuota() {
        return this.defaultResourceQuota;
    }

    public NamespaceProperties withDefaultResourceQuota(ResourceQuota defaultResourceQuota) {
        this.defaultResourceQuota = defaultResourceQuota;
        return this;
    }

    public NetworkPolicies defaultNetworkPolicy() {
        return this.defaultNetworkPolicy;
    }

    public NamespaceProperties withDefaultNetworkPolicy(NetworkPolicies defaultNetworkPolicy) {
        this.defaultNetworkPolicy = defaultNetworkPolicy;
        return this;
    }

    public AdoptionPolicy adoptionPolicy() {
        return this.adoptionPolicy;
    }

    public NamespaceProperties withAdoptionPolicy(AdoptionPolicy adoptionPolicy) {
        this.adoptionPolicy = adoptionPolicy;
        return this;
    }

    public DeletePolicy deletePolicy() {
        return this.deletePolicy;
    }

    public NamespaceProperties withDeletePolicy(DeletePolicy deletePolicy) {
        this.deletePolicy = deletePolicy;
        return this;
    }

    public void validate() {
        if (this.defaultResourceQuota() != null) {
            this.defaultResourceQuota().validate();
        }
        if (this.defaultNetworkPolicy() != null) {
            this.defaultNetworkPolicy().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("labels", this.labels, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("annotations", this.annotations, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("defaultResourceQuota", (JsonSerializable)this.defaultResourceQuota);
        jsonWriter.writeJsonField("defaultNetworkPolicy", (JsonSerializable)this.defaultNetworkPolicy);
        jsonWriter.writeStringField("adoptionPolicy", this.adoptionPolicy == null ? null : this.adoptionPolicy.toString());
        jsonWriter.writeStringField("deletePolicy", this.deletePolicy == null ? null : this.deletePolicy.toString());
        return jsonWriter.writeEndObject();
    }

    public static NamespaceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (NamespaceProperties)jsonReader.readObject(reader -> {
            NamespaceProperties deserializedNamespaceProperties = new NamespaceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedNamespaceProperties.provisioningState = NamespaceProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("labels".equals(fieldName)) {
                    Map labels;
                    deserializedNamespaceProperties.labels = labels = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    Map annotations;
                    deserializedNamespaceProperties.annotations = annotations = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("portalFqdn".equals(fieldName)) {
                    deserializedNamespaceProperties.portalFqdn = reader.getString();
                    continue;
                }
                if ("defaultResourceQuota".equals(fieldName)) {
                    deserializedNamespaceProperties.defaultResourceQuota = ResourceQuota.fromJson(reader);
                    continue;
                }
                if ("defaultNetworkPolicy".equals(fieldName)) {
                    deserializedNamespaceProperties.defaultNetworkPolicy = NetworkPolicies.fromJson(reader);
                    continue;
                }
                if ("adoptionPolicy".equals(fieldName)) {
                    deserializedNamespaceProperties.adoptionPolicy = AdoptionPolicy.fromString(reader.getString());
                    continue;
                }
                if ("deletePolicy".equals(fieldName)) {
                    deserializedNamespaceProperties.deletePolicy = DeletePolicy.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNamespaceProperties;
        });
    }
}

