/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class ManagedClusterPodIdentityException
implements JsonSerializable<ManagedClusterPodIdentityException> {
    private String name;
    private String namespace;
    private Map<String, String> podLabels;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedClusterPodIdentityException.class);

    public String name() {
        return this.name;
    }

    public ManagedClusterPodIdentityException withName(String name) {
        this.name = name;
        return this;
    }

    public String namespace() {
        return this.namespace;
    }

    public ManagedClusterPodIdentityException withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public Map<String, String> podLabels() {
        return this.podLabels;
    }

    public ManagedClusterPodIdentityException withPodLabels(Map<String, String> podLabels) {
        this.podLabels = podLabels;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ManagedClusterPodIdentityException"));
        }
        if (this.namespace() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property namespace in model ManagedClusterPodIdentityException"));
        }
        if (this.podLabels() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property podLabels in model ManagedClusterPodIdentityException"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("namespace", this.namespace);
        jsonWriter.writeMapField("podLabels", this.podLabels, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ManagedClusterPodIdentityException fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedClusterPodIdentityException)jsonReader.readObject(reader -> {
            ManagedClusterPodIdentityException deserializedManagedClusterPodIdentityException = new ManagedClusterPodIdentityException();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedManagedClusterPodIdentityException.name = reader.getString();
                    continue;
                }
                if ("namespace".equals(fieldName)) {
                    deserializedManagedClusterPodIdentityException.namespace = reader.getString();
                    continue;
                }
                if ("podLabels".equals(fieldName)) {
                    Map podLabels;
                    deserializedManagedClusterPodIdentityException.podLabels = podLabels = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedClusterPodIdentityException;
        });
    }
}

