/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.LocalDnsMode;
import com.azure.resourcemanager.containerservice.models.LocalDnsOverride;
import com.azure.resourcemanager.containerservice.models.LocalDnsState;
import java.io.IOException;
import java.util.Map;

public final class LocalDnsProfile
implements JsonSerializable<LocalDnsProfile> {
    private LocalDnsMode mode;
    private LocalDnsState state;
    private Map<String, LocalDnsOverride> vnetDnsOverrides;
    private Map<String, LocalDnsOverride> kubeDnsOverrides;

    public LocalDnsMode mode() {
        return this.mode;
    }

    public LocalDnsProfile withMode(LocalDnsMode mode) {
        this.mode = mode;
        return this;
    }

    public LocalDnsState state() {
        return this.state;
    }

    public Map<String, LocalDnsOverride> vnetDnsOverrides() {
        return this.vnetDnsOverrides;
    }

    public LocalDnsProfile withVnetDnsOverrides(Map<String, LocalDnsOverride> vnetDnsOverrides) {
        this.vnetDnsOverrides = vnetDnsOverrides;
        return this;
    }

    public Map<String, LocalDnsOverride> kubeDnsOverrides() {
        return this.kubeDnsOverrides;
    }

    public LocalDnsProfile withKubeDnsOverrides(Map<String, LocalDnsOverride> kubeDnsOverrides) {
        this.kubeDnsOverrides = kubeDnsOverrides;
        return this;
    }

    public void validate() {
        if (this.vnetDnsOverrides() != null) {
            this.vnetDnsOverrides().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.kubeDnsOverrides() != null) {
            this.kubeDnsOverrides().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("mode", this.mode == null ? null : this.mode.toString());
        jsonWriter.writeMapField("vnetDNSOverrides", this.vnetDnsOverrides, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("kubeDNSOverrides", this.kubeDnsOverrides, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static LocalDnsProfile fromJson(JsonReader jsonReader) throws IOException {
        return (LocalDnsProfile)jsonReader.readObject(reader -> {
            LocalDnsProfile deserializedLocalDnsProfile = new LocalDnsProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("mode".equals(fieldName)) {
                    deserializedLocalDnsProfile.mode = LocalDnsMode.fromString(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedLocalDnsProfile.state = LocalDnsState.fromString(reader.getString());
                    continue;
                }
                if ("vnetDNSOverrides".equals(fieldName)) {
                    Map vnetDnsOverrides;
                    deserializedLocalDnsProfile.vnetDnsOverrides = vnetDnsOverrides = reader.readMap(reader1 -> LocalDnsOverride.fromJson(reader1));
                    continue;
                }
                if ("kubeDNSOverrides".equals(fieldName)) {
                    Map kubeDnsOverrides;
                    deserializedLocalDnsProfile.kubeDnsOverrides = kubeDnsOverrides = reader.readMap(reader1 -> LocalDnsOverride.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLocalDnsProfile;
        });
    }
}

