/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.fluent.models.MaintenanceConfigurationProperties;
import com.azure.resourcemanager.containerservice.models.MaintenanceWindow;
import com.azure.resourcemanager.containerservice.models.TimeInWeek;
import com.azure.resourcemanager.containerservice.models.TimeSpan;
import java.io.IOException;
import java.util.List;

public final class MaintenanceConfigurationInner
extends SubResource {
    private SystemData systemData;
    private MaintenanceConfigurationProperties innerProperties;
    private String name;
    private String type;

    public SystemData systemData() {
        return this.systemData;
    }

    private MaintenanceConfigurationProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public MaintenanceConfigurationInner withId(String id) {
        super.withId(id);
        return this;
    }

    public List<TimeInWeek> timeInWeek() {
        return this.innerProperties() == null ? null : this.innerProperties().timeInWeek();
    }

    public MaintenanceConfigurationInner withTimeInWeek(List<TimeInWeek> timeInWeek) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MaintenanceConfigurationProperties();
        }
        this.innerProperties().withTimeInWeek(timeInWeek);
        return this;
    }

    public List<TimeSpan> notAllowedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().notAllowedTime();
    }

    public MaintenanceConfigurationInner withNotAllowedTime(List<TimeSpan> notAllowedTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MaintenanceConfigurationProperties();
        }
        this.innerProperties().withNotAllowedTime(notAllowedTime);
        return this;
    }

    public MaintenanceWindow maintenanceWindow() {
        return this.innerProperties() == null ? null : this.innerProperties().maintenanceWindow();
    }

    public MaintenanceConfigurationInner withMaintenanceWindow(MaintenanceWindow maintenanceWindow) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MaintenanceConfigurationProperties();
        }
        this.innerProperties().withMaintenanceWindow(maintenanceWindow);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static MaintenanceConfigurationInner fromJson(JsonReader jsonReader) throws IOException {
        return (MaintenanceConfigurationInner)((Object)jsonReader.readObject(reader -> {
            MaintenanceConfigurationInner deserializedMaintenanceConfigurationInner = new MaintenanceConfigurationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMaintenanceConfigurationInner.withId(reader.getString());
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedMaintenanceConfigurationInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedMaintenanceConfigurationInner.innerProperties = MaintenanceConfigurationProperties.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMaintenanceConfigurationInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMaintenanceConfigurationInner.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMaintenanceConfigurationInner;
        }));
    }
}

