/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class TimeSpan
implements JsonSerializable<TimeSpan> {
    private OffsetDateTime start;
    private OffsetDateTime end;

    public OffsetDateTime start() {
        return this.start;
    }

    public TimeSpan withStart(OffsetDateTime start) {
        this.start = start;
        return this;
    }

    public OffsetDateTime end() {
        return this.end;
    }

    public TimeSpan withEnd(OffsetDateTime end) {
        this.end = end;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("start", this.start == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.start));
        jsonWriter.writeStringField("end", this.end == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.end));
        return jsonWriter.writeEndObject();
    }

    public static TimeSpan fromJson(JsonReader jsonReader) throws IOException {
        return (TimeSpan)jsonReader.readObject(reader -> {
            TimeSpan deserializedTimeSpan = new TimeSpan();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("start".equals(fieldName)) {
                    deserializedTimeSpan.start = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("end".equals(fieldName)) {
                    deserializedTimeSpan.end = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTimeSpan;
        });
    }
}

