/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Objects;

public final class DateSpan
implements JsonSerializable<DateSpan> {
    private LocalDate start;
    private LocalDate end;
    private static final ClientLogger LOGGER = new ClientLogger(DateSpan.class);

    public LocalDate start() {
        return this.start;
    }

    public DateSpan withStart(LocalDate start) {
        this.start = start;
        return this;
    }

    public LocalDate end() {
        return this.end;
    }

    public DateSpan withEnd(LocalDate end) {
        this.end = end;
        return this;
    }

    public void validate() {
        if (this.start() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property start in model DateSpan"));
        }
        if (this.end() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property end in model DateSpan"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("start", Objects.toString(this.start, null));
        jsonWriter.writeStringField("end", Objects.toString(this.end, null));
        return jsonWriter.writeEndObject();
    }

    public static DateSpan fromJson(JsonReader jsonReader) throws IOException {
        return (DateSpan)jsonReader.readObject(reader -> {
            DateSpan deserializedDateSpan = new DateSpan();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("start".equals(fieldName)) {
                    deserializedDateSpan.start = (LocalDate)reader.getNullable(nonNullReader -> LocalDate.parse(nonNullReader.getString()));
                    continue;
                }
                if ("end".equals(fieldName)) {
                    deserializedDateSpan.end = (LocalDate)reader.getNullable(nonNullReader -> LocalDate.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDateSpan;
        });
    }
}

