/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.fluent.models.PrivateLinkResourceInner;
import com.azure.resourcemanager.containerservice.models.ClusterUpgradeSettings;
import com.azure.resourcemanager.containerservice.models.ContainerServiceLinuxProfile;
import com.azure.resourcemanager.containerservice.models.ContainerServiceNetworkProfile;
import com.azure.resourcemanager.containerservice.models.KubernetesSupportPlan;
import com.azure.resourcemanager.containerservice.models.ManagedClusterAadProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterAddonProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterAgentPoolProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterApiServerAccessProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterAutoUpgradeProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterAzureMonitorProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterBootstrapProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterHttpProxyConfig;
import com.azure.resourcemanager.containerservice.models.ManagedClusterIngressProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterMetricsProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterNodeResourceGroupProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterOidcIssuerProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterPodIdentityProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterPropertiesAutoScalerProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterSecurityProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterServicePrincipalProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterStorageProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterWindowsProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterWorkloadAutoScalerProfile;
import com.azure.resourcemanager.containerservice.models.PowerState;
import com.azure.resourcemanager.containerservice.models.PublicNetworkAccess;
import com.azure.resourcemanager.containerservice.models.ServiceMeshProfile;
import com.azure.resourcemanager.containerservice.models.UserAssignedIdentity;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ManagedClusterProperties
implements JsonSerializable<ManagedClusterProperties> {
    private String provisioningState;
    private PowerState powerState;
    private Integer maxAgentPools;
    private String kubernetesVersion;
    private String currentKubernetesVersion;
    private String dnsPrefix;
    private String fqdnSubdomain;
    private String fqdn;
    private String privateFqdn;
    private String azurePortalFqdn;
    private List<ManagedClusterAgentPoolProfile> agentPoolProfiles;
    private ContainerServiceLinuxProfile linuxProfile;
    private ManagedClusterWindowsProfile windowsProfile;
    private ManagedClusterServicePrincipalProfile servicePrincipalProfile;
    private Map<String, ManagedClusterAddonProfile> addonProfiles;
    private ManagedClusterPodIdentityProfile podIdentityProfile;
    private ManagedClusterOidcIssuerProfile oidcIssuerProfile;
    private String nodeResourceGroup;
    private ManagedClusterNodeResourceGroupProfile nodeResourceGroupProfile;
    private Boolean enableRbac;
    private KubernetesSupportPlan supportPlan;
    private Boolean enablePodSecurityPolicy;
    private ContainerServiceNetworkProfile networkProfile;
    private ManagedClusterAadProfile aadProfile;
    private ManagedClusterAutoUpgradeProfile autoUpgradeProfile;
    private ClusterUpgradeSettings upgradeSettings;
    private ManagedClusterPropertiesAutoScalerProfile autoScalerProfile;
    private ManagedClusterApiServerAccessProfile apiServerAccessProfile;
    private String diskEncryptionSetId;
    private Map<String, UserAssignedIdentity> identityProfile;
    private List<PrivateLinkResourceInner> privateLinkResources;
    private Boolean disableLocalAccounts;
    private ManagedClusterHttpProxyConfig httpProxyConfig;
    private ManagedClusterSecurityProfile securityProfile;
    private ManagedClusterStorageProfile storageProfile;
    private ManagedClusterIngressProfile ingressProfile;
    private PublicNetworkAccess publicNetworkAccess;
    private ManagedClusterWorkloadAutoScalerProfile workloadAutoScalerProfile;
    private ManagedClusterAzureMonitorProfile azureMonitorProfile;
    private ServiceMeshProfile serviceMeshProfile;
    private String resourceUid;
    private ManagedClusterMetricsProfile metricsProfile;
    private ManagedClusterBootstrapProfile bootstrapProfile;

    public String provisioningState() {
        return this.provisioningState;
    }

    public PowerState powerState() {
        return this.powerState;
    }

    public Integer maxAgentPools() {
        return this.maxAgentPools;
    }

    public String kubernetesVersion() {
        return this.kubernetesVersion;
    }

    public ManagedClusterProperties withKubernetesVersion(String kubernetesVersion) {
        this.kubernetesVersion = kubernetesVersion;
        return this;
    }

    public String currentKubernetesVersion() {
        return this.currentKubernetesVersion;
    }

    public String dnsPrefix() {
        return this.dnsPrefix;
    }

    public ManagedClusterProperties withDnsPrefix(String dnsPrefix) {
        this.dnsPrefix = dnsPrefix;
        return this;
    }

    public String fqdnSubdomain() {
        return this.fqdnSubdomain;
    }

    public ManagedClusterProperties withFqdnSubdomain(String fqdnSubdomain) {
        this.fqdnSubdomain = fqdnSubdomain;
        return this;
    }

    public String fqdn() {
        return this.fqdn;
    }

    public String privateFqdn() {
        return this.privateFqdn;
    }

    public String azurePortalFqdn() {
        return this.azurePortalFqdn;
    }

    public List<ManagedClusterAgentPoolProfile> agentPoolProfiles() {
        return this.agentPoolProfiles;
    }

    public ManagedClusterProperties withAgentPoolProfiles(List<ManagedClusterAgentPoolProfile> agentPoolProfiles) {
        this.agentPoolProfiles = agentPoolProfiles;
        return this;
    }

    public ContainerServiceLinuxProfile linuxProfile() {
        return this.linuxProfile;
    }

    public ManagedClusterProperties withLinuxProfile(ContainerServiceLinuxProfile linuxProfile) {
        this.linuxProfile = linuxProfile;
        return this;
    }

    public ManagedClusterWindowsProfile windowsProfile() {
        return this.windowsProfile;
    }

    public ManagedClusterProperties withWindowsProfile(ManagedClusterWindowsProfile windowsProfile) {
        this.windowsProfile = windowsProfile;
        return this;
    }

    public ManagedClusterServicePrincipalProfile servicePrincipalProfile() {
        return this.servicePrincipalProfile;
    }

    public ManagedClusterProperties withServicePrincipalProfile(ManagedClusterServicePrincipalProfile servicePrincipalProfile) {
        this.servicePrincipalProfile = servicePrincipalProfile;
        return this;
    }

    public Map<String, ManagedClusterAddonProfile> addonProfiles() {
        return this.addonProfiles;
    }

    public ManagedClusterProperties withAddonProfiles(Map<String, ManagedClusterAddonProfile> addonProfiles) {
        this.addonProfiles = addonProfiles;
        return this;
    }

    public ManagedClusterPodIdentityProfile podIdentityProfile() {
        return this.podIdentityProfile;
    }

    public ManagedClusterProperties withPodIdentityProfile(ManagedClusterPodIdentityProfile podIdentityProfile) {
        this.podIdentityProfile = podIdentityProfile;
        return this;
    }

    public ManagedClusterOidcIssuerProfile oidcIssuerProfile() {
        return this.oidcIssuerProfile;
    }

    public ManagedClusterProperties withOidcIssuerProfile(ManagedClusterOidcIssuerProfile oidcIssuerProfile) {
        this.oidcIssuerProfile = oidcIssuerProfile;
        return this;
    }

    public String nodeResourceGroup() {
        return this.nodeResourceGroup;
    }

    public ManagedClusterProperties withNodeResourceGroup(String nodeResourceGroup) {
        this.nodeResourceGroup = nodeResourceGroup;
        return this;
    }

    public ManagedClusterNodeResourceGroupProfile nodeResourceGroupProfile() {
        return this.nodeResourceGroupProfile;
    }

    public ManagedClusterProperties withNodeResourceGroupProfile(ManagedClusterNodeResourceGroupProfile nodeResourceGroupProfile) {
        this.nodeResourceGroupProfile = nodeResourceGroupProfile;
        return this;
    }

    public Boolean enableRbac() {
        return this.enableRbac;
    }

    public ManagedClusterProperties withEnableRbac(Boolean enableRbac) {
        this.enableRbac = enableRbac;
        return this;
    }

    public KubernetesSupportPlan supportPlan() {
        return this.supportPlan;
    }

    public ManagedClusterProperties withSupportPlan(KubernetesSupportPlan supportPlan) {
        this.supportPlan = supportPlan;
        return this;
    }

    public Boolean enablePodSecurityPolicy() {
        return this.enablePodSecurityPolicy;
    }

    public ManagedClusterProperties withEnablePodSecurityPolicy(Boolean enablePodSecurityPolicy) {
        this.enablePodSecurityPolicy = enablePodSecurityPolicy;
        return this;
    }

    public ContainerServiceNetworkProfile networkProfile() {
        return this.networkProfile;
    }

    public ManagedClusterProperties withNetworkProfile(ContainerServiceNetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    public ManagedClusterAadProfile aadProfile() {
        return this.aadProfile;
    }

    public ManagedClusterProperties withAadProfile(ManagedClusterAadProfile aadProfile) {
        this.aadProfile = aadProfile;
        return this;
    }

    public ManagedClusterAutoUpgradeProfile autoUpgradeProfile() {
        return this.autoUpgradeProfile;
    }

    public ManagedClusterProperties withAutoUpgradeProfile(ManagedClusterAutoUpgradeProfile autoUpgradeProfile) {
        this.autoUpgradeProfile = autoUpgradeProfile;
        return this;
    }

    public ClusterUpgradeSettings upgradeSettings() {
        return this.upgradeSettings;
    }

    public ManagedClusterProperties withUpgradeSettings(ClusterUpgradeSettings upgradeSettings) {
        this.upgradeSettings = upgradeSettings;
        return this;
    }

    public ManagedClusterPropertiesAutoScalerProfile autoScalerProfile() {
        return this.autoScalerProfile;
    }

    public ManagedClusterProperties withAutoScalerProfile(ManagedClusterPropertiesAutoScalerProfile autoScalerProfile) {
        this.autoScalerProfile = autoScalerProfile;
        return this;
    }

    public ManagedClusterApiServerAccessProfile apiServerAccessProfile() {
        return this.apiServerAccessProfile;
    }

    public ManagedClusterProperties withApiServerAccessProfile(ManagedClusterApiServerAccessProfile apiServerAccessProfile) {
        this.apiServerAccessProfile = apiServerAccessProfile;
        return this;
    }

    public String diskEncryptionSetId() {
        return this.diskEncryptionSetId;
    }

    public ManagedClusterProperties withDiskEncryptionSetId(String diskEncryptionSetId) {
        this.diskEncryptionSetId = diskEncryptionSetId;
        return this;
    }

    public Map<String, UserAssignedIdentity> identityProfile() {
        return this.identityProfile;
    }

    public ManagedClusterProperties withIdentityProfile(Map<String, UserAssignedIdentity> identityProfile) {
        this.identityProfile = identityProfile;
        return this;
    }

    public List<PrivateLinkResourceInner> privateLinkResources() {
        return this.privateLinkResources;
    }

    public ManagedClusterProperties withPrivateLinkResources(List<PrivateLinkResourceInner> privateLinkResources) {
        this.privateLinkResources = privateLinkResources;
        return this;
    }

    public Boolean disableLocalAccounts() {
        return this.disableLocalAccounts;
    }

    public ManagedClusterProperties withDisableLocalAccounts(Boolean disableLocalAccounts) {
        this.disableLocalAccounts = disableLocalAccounts;
        return this;
    }

    public ManagedClusterHttpProxyConfig httpProxyConfig() {
        return this.httpProxyConfig;
    }

    public ManagedClusterProperties withHttpProxyConfig(ManagedClusterHttpProxyConfig httpProxyConfig) {
        this.httpProxyConfig = httpProxyConfig;
        return this;
    }

    public ManagedClusterSecurityProfile securityProfile() {
        return this.securityProfile;
    }

    public ManagedClusterProperties withSecurityProfile(ManagedClusterSecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    public ManagedClusterStorageProfile storageProfile() {
        return this.storageProfile;
    }

    public ManagedClusterProperties withStorageProfile(ManagedClusterStorageProfile storageProfile) {
        this.storageProfile = storageProfile;
        return this;
    }

    public ManagedClusterIngressProfile ingressProfile() {
        return this.ingressProfile;
    }

    public ManagedClusterProperties withIngressProfile(ManagedClusterIngressProfile ingressProfile) {
        this.ingressProfile = ingressProfile;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public ManagedClusterProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public ManagedClusterWorkloadAutoScalerProfile workloadAutoScalerProfile() {
        return this.workloadAutoScalerProfile;
    }

    public ManagedClusterProperties withWorkloadAutoScalerProfile(ManagedClusterWorkloadAutoScalerProfile workloadAutoScalerProfile) {
        this.workloadAutoScalerProfile = workloadAutoScalerProfile;
        return this;
    }

    public ManagedClusterAzureMonitorProfile azureMonitorProfile() {
        return this.azureMonitorProfile;
    }

    public ManagedClusterProperties withAzureMonitorProfile(ManagedClusterAzureMonitorProfile azureMonitorProfile) {
        this.azureMonitorProfile = azureMonitorProfile;
        return this;
    }

    public ServiceMeshProfile serviceMeshProfile() {
        return this.serviceMeshProfile;
    }

    public ManagedClusterProperties withServiceMeshProfile(ServiceMeshProfile serviceMeshProfile) {
        this.serviceMeshProfile = serviceMeshProfile;
        return this;
    }

    public String resourceUid() {
        return this.resourceUid;
    }

    public ManagedClusterMetricsProfile metricsProfile() {
        return this.metricsProfile;
    }

    public ManagedClusterProperties withMetricsProfile(ManagedClusterMetricsProfile metricsProfile) {
        this.metricsProfile = metricsProfile;
        return this;
    }

    public ManagedClusterBootstrapProfile bootstrapProfile() {
        return this.bootstrapProfile;
    }

    public ManagedClusterProperties withBootstrapProfile(ManagedClusterBootstrapProfile bootstrapProfile) {
        this.bootstrapProfile = bootstrapProfile;
        return this;
    }

    public void validate() {
        if (this.powerState() != null) {
            this.powerState().validate();
        }
        if (this.agentPoolProfiles() != null) {
            this.agentPoolProfiles().forEach(e -> e.validate());
        }
        if (this.linuxProfile() != null) {
            this.linuxProfile().validate();
        }
        if (this.windowsProfile() != null) {
            this.windowsProfile().validate();
        }
        if (this.servicePrincipalProfile() != null) {
            this.servicePrincipalProfile().validate();
        }
        if (this.addonProfiles() != null) {
            this.addonProfiles().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.podIdentityProfile() != null) {
            this.podIdentityProfile().validate();
        }
        if (this.oidcIssuerProfile() != null) {
            this.oidcIssuerProfile().validate();
        }
        if (this.nodeResourceGroupProfile() != null) {
            this.nodeResourceGroupProfile().validate();
        }
        if (this.networkProfile() != null) {
            this.networkProfile().validate();
        }
        if (this.aadProfile() != null) {
            this.aadProfile().validate();
        }
        if (this.autoUpgradeProfile() != null) {
            this.autoUpgradeProfile().validate();
        }
        if (this.upgradeSettings() != null) {
            this.upgradeSettings().validate();
        }
        if (this.autoScalerProfile() != null) {
            this.autoScalerProfile().validate();
        }
        if (this.apiServerAccessProfile() != null) {
            this.apiServerAccessProfile().validate();
        }
        if (this.identityProfile() != null) {
            this.identityProfile().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.privateLinkResources() != null) {
            this.privateLinkResources().forEach(e -> e.validate());
        }
        if (this.httpProxyConfig() != null) {
            this.httpProxyConfig().validate();
        }
        if (this.securityProfile() != null) {
            this.securityProfile().validate();
        }
        if (this.storageProfile() != null) {
            this.storageProfile().validate();
        }
        if (this.ingressProfile() != null) {
            this.ingressProfile().validate();
        }
        if (this.workloadAutoScalerProfile() != null) {
            this.workloadAutoScalerProfile().validate();
        }
        if (this.azureMonitorProfile() != null) {
            this.azureMonitorProfile().validate();
        }
        if (this.serviceMeshProfile() != null) {
            this.serviceMeshProfile().validate();
        }
        if (this.metricsProfile() != null) {
            this.metricsProfile().validate();
        }
        if (this.bootstrapProfile() != null) {
            this.bootstrapProfile().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kubernetesVersion", this.kubernetesVersion);
        jsonWriter.writeStringField("dnsPrefix", this.dnsPrefix);
        jsonWriter.writeStringField("fqdnSubdomain", this.fqdnSubdomain);
        jsonWriter.writeArrayField("agentPoolProfiles", this.agentPoolProfiles, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linuxProfile", (JsonSerializable)this.linuxProfile);
        jsonWriter.writeJsonField("windowsProfile", (JsonSerializable)this.windowsProfile);
        jsonWriter.writeJsonField("servicePrincipalProfile", (JsonSerializable)this.servicePrincipalProfile);
        jsonWriter.writeMapField("addonProfiles", this.addonProfiles, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("podIdentityProfile", (JsonSerializable)this.podIdentityProfile);
        jsonWriter.writeJsonField("oidcIssuerProfile", (JsonSerializable)this.oidcIssuerProfile);
        jsonWriter.writeStringField("nodeResourceGroup", this.nodeResourceGroup);
        jsonWriter.writeJsonField("nodeResourceGroupProfile", (JsonSerializable)this.nodeResourceGroupProfile);
        jsonWriter.writeBooleanField("enableRBAC", this.enableRbac);
        jsonWriter.writeStringField("supportPlan", this.supportPlan == null ? null : this.supportPlan.toString());
        jsonWriter.writeBooleanField("enablePodSecurityPolicy", this.enablePodSecurityPolicy);
        jsonWriter.writeJsonField("networkProfile", (JsonSerializable)this.networkProfile);
        jsonWriter.writeJsonField("aadProfile", (JsonSerializable)this.aadProfile);
        jsonWriter.writeJsonField("autoUpgradeProfile", (JsonSerializable)this.autoUpgradeProfile);
        jsonWriter.writeJsonField("upgradeSettings", (JsonSerializable)this.upgradeSettings);
        jsonWriter.writeJsonField("autoScalerProfile", (JsonSerializable)this.autoScalerProfile);
        jsonWriter.writeJsonField("apiServerAccessProfile", (JsonSerializable)this.apiServerAccessProfile);
        jsonWriter.writeStringField("diskEncryptionSetID", this.diskEncryptionSetId);
        jsonWriter.writeMapField("identityProfile", this.identityProfile, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("privateLinkResources", this.privateLinkResources, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("disableLocalAccounts", this.disableLocalAccounts);
        jsonWriter.writeJsonField("httpProxyConfig", (JsonSerializable)this.httpProxyConfig);
        jsonWriter.writeJsonField("securityProfile", (JsonSerializable)this.securityProfile);
        jsonWriter.writeJsonField("storageProfile", (JsonSerializable)this.storageProfile);
        jsonWriter.writeJsonField("ingressProfile", (JsonSerializable)this.ingressProfile);
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeJsonField("workloadAutoScalerProfile", (JsonSerializable)this.workloadAutoScalerProfile);
        jsonWriter.writeJsonField("azureMonitorProfile", (JsonSerializable)this.azureMonitorProfile);
        jsonWriter.writeJsonField("serviceMeshProfile", (JsonSerializable)this.serviceMeshProfile);
        jsonWriter.writeJsonField("metricsProfile", (JsonSerializable)this.metricsProfile);
        jsonWriter.writeJsonField("bootstrapProfile", (JsonSerializable)this.bootstrapProfile);
        return jsonWriter.writeEndObject();
    }

    public static ManagedClusterProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedClusterProperties)jsonReader.readObject(reader -> {
            ManagedClusterProperties deserializedManagedClusterProperties = new ManagedClusterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedManagedClusterProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("powerState".equals(fieldName)) {
                    deserializedManagedClusterProperties.powerState = PowerState.fromJson(reader);
                    continue;
                }
                if ("maxAgentPools".equals(fieldName)) {
                    deserializedManagedClusterProperties.maxAgentPools = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("kubernetesVersion".equals(fieldName)) {
                    deserializedManagedClusterProperties.kubernetesVersion = reader.getString();
                    continue;
                }
                if ("currentKubernetesVersion".equals(fieldName)) {
                    deserializedManagedClusterProperties.currentKubernetesVersion = reader.getString();
                    continue;
                }
                if ("dnsPrefix".equals(fieldName)) {
                    deserializedManagedClusterProperties.dnsPrefix = reader.getString();
                    continue;
                }
                if ("fqdnSubdomain".equals(fieldName)) {
                    deserializedManagedClusterProperties.fqdnSubdomain = reader.getString();
                    continue;
                }
                if ("fqdn".equals(fieldName)) {
                    deserializedManagedClusterProperties.fqdn = reader.getString();
                    continue;
                }
                if ("privateFQDN".equals(fieldName)) {
                    deserializedManagedClusterProperties.privateFqdn = reader.getString();
                    continue;
                }
                if ("azurePortalFQDN".equals(fieldName)) {
                    deserializedManagedClusterProperties.azurePortalFqdn = reader.getString();
                    continue;
                }
                if ("agentPoolProfiles".equals(fieldName)) {
                    List agentPoolProfiles;
                    deserializedManagedClusterProperties.agentPoolProfiles = agentPoolProfiles = reader.readArray(reader1 -> ManagedClusterAgentPoolProfile.fromJson(reader1));
                    continue;
                }
                if ("linuxProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.linuxProfile = ContainerServiceLinuxProfile.fromJson(reader);
                    continue;
                }
                if ("windowsProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.windowsProfile = ManagedClusterWindowsProfile.fromJson(reader);
                    continue;
                }
                if ("servicePrincipalProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.servicePrincipalProfile = ManagedClusterServicePrincipalProfile.fromJson(reader);
                    continue;
                }
                if ("addonProfiles".equals(fieldName)) {
                    Map addonProfiles;
                    deserializedManagedClusterProperties.addonProfiles = addonProfiles = reader.readMap(reader1 -> ManagedClusterAddonProfile.fromJson(reader1));
                    continue;
                }
                if ("podIdentityProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.podIdentityProfile = ManagedClusterPodIdentityProfile.fromJson(reader);
                    continue;
                }
                if ("oidcIssuerProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.oidcIssuerProfile = ManagedClusterOidcIssuerProfile.fromJson(reader);
                    continue;
                }
                if ("nodeResourceGroup".equals(fieldName)) {
                    deserializedManagedClusterProperties.nodeResourceGroup = reader.getString();
                    continue;
                }
                if ("nodeResourceGroupProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.nodeResourceGroupProfile = ManagedClusterNodeResourceGroupProfile.fromJson(reader);
                    continue;
                }
                if ("enableRBAC".equals(fieldName)) {
                    deserializedManagedClusterProperties.enableRbac = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("supportPlan".equals(fieldName)) {
                    deserializedManagedClusterProperties.supportPlan = KubernetesSupportPlan.fromString(reader.getString());
                    continue;
                }
                if ("enablePodSecurityPolicy".equals(fieldName)) {
                    deserializedManagedClusterProperties.enablePodSecurityPolicy = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("networkProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.networkProfile = ContainerServiceNetworkProfile.fromJson(reader);
                    continue;
                }
                if ("aadProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.aadProfile = ManagedClusterAadProfile.fromJson(reader);
                    continue;
                }
                if ("autoUpgradeProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.autoUpgradeProfile = ManagedClusterAutoUpgradeProfile.fromJson(reader);
                    continue;
                }
                if ("upgradeSettings".equals(fieldName)) {
                    deserializedManagedClusterProperties.upgradeSettings = ClusterUpgradeSettings.fromJson(reader);
                    continue;
                }
                if ("autoScalerProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.autoScalerProfile = ManagedClusterPropertiesAutoScalerProfile.fromJson(reader);
                    continue;
                }
                if ("apiServerAccessProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.apiServerAccessProfile = ManagedClusterApiServerAccessProfile.fromJson(reader);
                    continue;
                }
                if ("diskEncryptionSetID".equals(fieldName)) {
                    deserializedManagedClusterProperties.diskEncryptionSetId = reader.getString();
                    continue;
                }
                if ("identityProfile".equals(fieldName)) {
                    Map identityProfile;
                    deserializedManagedClusterProperties.identityProfile = identityProfile = reader.readMap(reader1 -> UserAssignedIdentity.fromJson(reader1));
                    continue;
                }
                if ("privateLinkResources".equals(fieldName)) {
                    List privateLinkResources;
                    deserializedManagedClusterProperties.privateLinkResources = privateLinkResources = reader.readArray(reader1 -> PrivateLinkResourceInner.fromJson(reader1));
                    continue;
                }
                if ("disableLocalAccounts".equals(fieldName)) {
                    deserializedManagedClusterProperties.disableLocalAccounts = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("httpProxyConfig".equals(fieldName)) {
                    deserializedManagedClusterProperties.httpProxyConfig = ManagedClusterHttpProxyConfig.fromJson(reader);
                    continue;
                }
                if ("securityProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.securityProfile = ManagedClusterSecurityProfile.fromJson(reader);
                    continue;
                }
                if ("storageProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.storageProfile = ManagedClusterStorageProfile.fromJson(reader);
                    continue;
                }
                if ("ingressProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.ingressProfile = ManagedClusterIngressProfile.fromJson(reader);
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedManagedClusterProperties.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                if ("workloadAutoScalerProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.workloadAutoScalerProfile = ManagedClusterWorkloadAutoScalerProfile.fromJson(reader);
                    continue;
                }
                if ("azureMonitorProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.azureMonitorProfile = ManagedClusterAzureMonitorProfile.fromJson(reader);
                    continue;
                }
                if ("serviceMeshProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.serviceMeshProfile = ServiceMeshProfile.fromJson(reader);
                    continue;
                }
                if ("resourceUID".equals(fieldName)) {
                    deserializedManagedClusterProperties.resourceUid = reader.getString();
                    continue;
                }
                if ("metricsProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.metricsProfile = ManagedClusterMetricsProfile.fromJson(reader);
                    continue;
                }
                if ("bootstrapProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.bootstrapProfile = ManagedClusterBootstrapProfile.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedClusterProperties;
        });
    }
}

