/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.UserAssignedIdentity;
import java.io.IOException;
import java.util.List;

public final class ManagedClusterIngressProfileWebAppRouting
implements JsonSerializable<ManagedClusterIngressProfileWebAppRouting> {
    private Boolean enabled;
    private List<String> dnsZoneResourceIds;
    private UserAssignedIdentity identity;

    public Boolean enabled() {
        return this.enabled;
    }

    public ManagedClusterIngressProfileWebAppRouting withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public List<String> dnsZoneResourceIds() {
        return this.dnsZoneResourceIds;
    }

    public ManagedClusterIngressProfileWebAppRouting withDnsZoneResourceIds(List<String> dnsZoneResourceIds) {
        this.dnsZoneResourceIds = dnsZoneResourceIds;
        return this;
    }

    public UserAssignedIdentity identity() {
        return this.identity;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeArrayField("dnsZoneResourceIds", this.dnsZoneResourceIds, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ManagedClusterIngressProfileWebAppRouting fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedClusterIngressProfileWebAppRouting)jsonReader.readObject(reader -> {
            ManagedClusterIngressProfileWebAppRouting deserializedManagedClusterIngressProfileWebAppRouting = new ManagedClusterIngressProfileWebAppRouting();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedManagedClusterIngressProfileWebAppRouting.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("dnsZoneResourceIds".equals(fieldName)) {
                    List dnsZoneResourceIds;
                    deserializedManagedClusterIngressProfileWebAppRouting.dnsZoneResourceIds = dnsZoneResourceIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedManagedClusterIngressProfileWebAppRouting.identity = UserAssignedIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedClusterIngressProfileWebAppRouting;
        });
    }
}

