/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.resourcemanager.containerservice.models.AgentPool;
import com.azure.resourcemanager.containerservice.models.AgentPoolMode;
import com.azure.resourcemanager.containerservice.models.AgentPoolType;
import com.azure.resourcemanager.containerservice.models.ContainerServiceVMSizeTypes;
import com.azure.resourcemanager.containerservice.models.KubeletDiskType;
import com.azure.resourcemanager.containerservice.models.KubernetesCluster;
import com.azure.resourcemanager.containerservice.models.ManagedClusterAgentPoolProfile;
import com.azure.resourcemanager.containerservice.models.OSDiskType;
import com.azure.resourcemanager.containerservice.models.OSType;
import com.azure.resourcemanager.containerservice.models.PowerState;
import com.azure.resourcemanager.containerservice.models.ScaleSetEvictionPolicy;
import com.azure.resourcemanager.containerservice.models.ScaleSetPriority;
import com.azure.resourcemanager.resources.fluentcore.arm.models.ChildResource;
import com.azure.resourcemanager.resources.fluentcore.model.Attachable;
import com.azure.resourcemanager.resources.fluentcore.model.HasInnerModel;
import com.azure.resourcemanager.resources.fluentcore.model.Settable;
import java.util.List;
import java.util.Map;

public interface KubernetesClusterAgentPool
extends ChildResource<KubernetesCluster>,
HasInnerModel<ManagedClusterAgentPoolProfile>,
AgentPool {
    @Override
    public String provisioningState();

    @Override
    public int count();

    @Override
    public ContainerServiceVMSizeTypes vmSize();

    @Override
    public int osDiskSizeInGB();

    @Override
    public OSType osType();

    @Override
    public AgentPoolType type();

    @Override
    public AgentPoolMode mode();

    @Override
    public String subnetName();

    @Override
    public String networkId();

    @Override
    public List<String> availabilityZones();

    @Override
    public Map<String, String> nodeLabels();

    @Override
    public List<String> nodeTaints();

    @Override
    public PowerState powerState();

    @Override
    public int nodeSize();

    @Override
    public int maximumPodsPerNode();

    @Override
    public boolean isAutoScalingEnabled();

    @Override
    public int minimumNodeSize();

    @Override
    public int maximumNodeSize();

    @Override
    public ScaleSetPriority virtualMachinePriority();

    @Override
    public ScaleSetEvictionPolicy virtualMachineEvictionPolicy();

    @Override
    public Double virtualMachineMaximumPrice();

    @Override
    public OSDiskType osDiskType();

    @Override
    public KubeletDiskType kubeletDiskType();

    @Override
    public Map<String, String> tags();

    public static interface UpdateStages {

        public static interface WithDiskType<ParentT> {
            public Update<ParentT> withKubeletDiskType(KubeletDiskType var1);
        }

        public static interface WithAutoScaling<ParentT> {
            public Update<ParentT> withAutoScaling(int var1, int var2);

            public Update<ParentT> withoutAutoScaling();
        }

        public static interface WithTags<ParentT> {
            public Update<ParentT> withTags(Map<String, String> var1);

            public Update<ParentT> withTag(String var1, String var2);

            public Update<ParentT> withoutTag(String var1);
        }

        public static interface WithAgentPoolMode<ParentT> {
            public Update<ParentT> withAgentPoolMode(AgentPoolMode var1);
        }

        public static interface WithAgentPoolVirtualMachineCount<ParentT> {
            public Update<ParentT> withAgentPoolVirtualMachineCount(int var1);
        }
    }

    public static interface Update<ParentT>
    extends Settable<ParentT>,
    UpdateStages.WithAgentPoolVirtualMachineCount<ParentT>,
    UpdateStages.WithAutoScaling<ParentT>,
    UpdateStages.WithAgentPoolMode<ParentT>,
    UpdateStages.WithDiskType<ParentT>,
    UpdateStages.WithTags<ParentT> {
    }

    public static interface DefinitionStages {

        public static interface WithAttach<ParentT>
        extends WithOSType<ParentT>,
        WithOSDiskSize<ParentT>,
        WithAgentPoolType<ParentT>,
        WithAgentPoolVirtualMachineCount<ParentT>,
        WithMaxPodsCount<ParentT>,
        WithVirtualNetwork<ParentT>,
        WithAgentPoolMode<ParentT>,
        WithAutoScaling<ParentT>,
        WithAvailabilityZones<ParentT>,
        WithNodeLabelsTaints<ParentT>,
        WithVMPriority<ParentT>,
        WithBillingProfile<ParentT>,
        WithDiskType<ParentT>,
        WithFips<ParentT>,
        WithTags<ParentT>,
        Attachable.InDefinition<ParentT> {
        }

        public static interface WithFips<ParentT> {
            public WithAttach<ParentT> withFipsEnabled();
        }

        public static interface WithDiskType<ParentT> {
            public WithAttach<ParentT> withOSDiskType(OSDiskType var1);

            public WithAttach<ParentT> withKubeletDiskType(KubeletDiskType var1);
        }

        public static interface WithBillingProfile<ParentT> {
            public WithAttach<ParentT> withVirtualMachineMaximumPrice(Double var1);
        }

        public static interface WithVMPriority<ParentT> {
            public WithAttach<ParentT> withVirtualMachinePriority(ScaleSetPriority var1);

            public WithAttach<ParentT> withSpotPriorityVirtualMachine();

            public WithAttach<ParentT> withSpotPriorityVirtualMachine(ScaleSetEvictionPolicy var1);
        }

        public static interface WithAgentPoolMode<ParentT> {
            public WithAttach<ParentT> withAgentPoolMode(AgentPoolMode var1);
        }

        public static interface WithVirtualNetwork<ParentT> {
            public WithAttach<ParentT> withVirtualNetwork(String var1, String var2);
        }

        public static interface WithTags<ParentT> {
            public WithAttach<ParentT> withTags(Map<String, String> var1);

            public WithAttach<ParentT> withTag(String var1, String var2);
        }

        public static interface WithNodeLabelsTaints<ParentT> {
            public WithAttach<ParentT> withNodeLabels(Map<String, String> var1);

            public WithAttach<ParentT> withNodeTaints(List<String> var1);
        }

        public static interface WithAvailabilityZones<ParentT> {
            public WithAttach<ParentT> withAvailabilityZones(Integer ... var1);
        }

        public static interface WithAutoScaling<ParentT> {
            public WithAttach<ParentT> withAutoScaling(int var1, int var2);
        }

        public static interface WithMaxPodsCount<ParentT> {
            public WithAttach<ParentT> withMaxPodsCount(int var1);
        }

        public static interface WithAgentPoolVirtualMachineCount<ParentT> {
            public WithAttach<ParentT> withAgentPoolVirtualMachineCount(int var1);
        }

        public static interface WithAgentPoolType<ParentT> {
            public WithAttach<ParentT> withAgentPoolType(AgentPoolType var1);

            public WithAttach<ParentT> withAgentPoolTypeName(String var1);
        }

        public static interface WithOSDiskSize<ParentT> {
            public WithAttach<ParentT> withOSDiskSizeInGB(int var1);
        }

        public static interface WithOSType<ParentT> {
            public WithAttach<ParentT> withOSType(OSType var1);
        }

        public static interface Blank<ParentT> {
            public WithAgentPoolVirtualMachineCount<ParentT> withVirtualMachineSize(ContainerServiceVMSizeTypes var1);
        }
    }

    public static interface Definition<ParentT>
    extends DefinitionStages.Blank<ParentT>,
    DefinitionStages.WithOSType<ParentT>,
    DefinitionStages.WithOSDiskSize<ParentT>,
    DefinitionStages.WithAgentPoolType<ParentT>,
    DefinitionStages.WithAgentPoolVirtualMachineCount<ParentT>,
    DefinitionStages.WithMaxPodsCount<ParentT>,
    DefinitionStages.WithVirtualNetwork<ParentT>,
    DefinitionStages.WithAttach<ParentT> {
    }
}

