/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.RunRequest;
import com.azure.resourcemanager.containerregistry.models.SetValue;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="TaskRunRequest")
public final class TaskRunRequest
extends RunRequest {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(TaskRunRequest.class);
    @JsonProperty(value="taskName", required=true)
    private String taskName;
    @JsonProperty(value="values")
    private List<SetValue> values;

    public String taskName() {
        return this.taskName;
    }

    public TaskRunRequest withTaskName(String taskName) {
        this.taskName = taskName;
        return this;
    }

    public List<SetValue> values() {
        return this.values;
    }

    public TaskRunRequest withValues(List<SetValue> values) {
        this.values = values;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.taskName() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property taskName in model TaskRunRequest"));
        }
        if (this.values() != null) {
            this.values().forEach(e -> e.validate());
        }
    }
}

