/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.containerregistry.fluent.ConnectedRegistriesClient;
import com.azure.resourcemanager.containerregistry.fluent.models.ConnectedRegistryInner;
import com.azure.resourcemanager.containerregistry.implementation.ContainerRegistryManagementClientImpl;
import com.azure.resourcemanager.containerregistry.models.ConnectedRegistryListResult;
import com.azure.resourcemanager.containerregistry.models.ConnectedRegistryUpdateParameters;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ConnectedRegistriesClientImpl
implements ConnectedRegistriesClient {
    private final ConnectedRegistriesService service;
    private final ContainerRegistryManagementClientImpl client;

    ConnectedRegistriesClientImpl(ContainerRegistryManagementClientImpl client) {
        this.service = (ConnectedRegistriesService)RestProxy.create(ConnectedRegistriesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ConnectedRegistryInner>> listSinglePageAsync(String resourceGroupName, String registryName, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        String apiVersion = "2025-11-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2025-11-01", this.client.getSubscriptionId(), resourceGroupName, registryName, filter, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConnectedRegistryListResult)res.getValue()).value(), ((ConnectedRegistryListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ConnectedRegistryInner>> listSinglePageAsync(String resourceGroupName, String registryName, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        String apiVersion = "2025-11-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2025-11-01", this.client.getSubscriptionId(), resourceGroupName, registryName, filter, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConnectedRegistryListResult)res.getValue()).value(), ((ConnectedRegistryListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ConnectedRegistryInner> listAsync(String resourceGroupName, String registryName, String filter) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, registryName, filter), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ConnectedRegistryInner> listAsync(String resourceGroupName, String registryName) {
        String filter = null;
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, registryName, filter), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ConnectedRegistryInner> listAsync(String resourceGroupName, String registryName, String filter, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, registryName, filter, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConnectedRegistryInner> list(String resourceGroupName, String registryName) {
        String filter = null;
        return new PagedIterable(this.listAsync(resourceGroupName, registryName, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConnectedRegistryInner> list(String resourceGroupName, String registryName, String filter, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, registryName, filter, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ConnectedRegistryInner>> getWithResponseAsync(String resourceGroupName, String registryName, String connectedRegistryName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (connectedRegistryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedRegistryName is required and cannot be null."));
        }
        String apiVersion = "2025-11-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2025-11-01", this.client.getSubscriptionId(), resourceGroupName, registryName, connectedRegistryName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ConnectedRegistryInner>> getWithResponseAsync(String resourceGroupName, String registryName, String connectedRegistryName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (connectedRegistryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedRegistryName is required and cannot be null."));
        }
        String apiVersion = "2025-11-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), "2025-11-01", this.client.getSubscriptionId(), resourceGroupName, registryName, connectedRegistryName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConnectedRegistryInner> getAsync(String resourceGroupName, String registryName, String connectedRegistryName) {
        return this.getWithResponseAsync(resourceGroupName, registryName, connectedRegistryName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ConnectedRegistryInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ConnectedRegistryInner> getWithResponse(String resourceGroupName, String registryName, String connectedRegistryName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, registryName, connectedRegistryName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConnectedRegistryInner get(String resourceGroupName, String registryName, String connectedRegistryName) {
        return (ConnectedRegistryInner)((Object)this.getWithResponse(resourceGroupName, registryName, connectedRegistryName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String registryName, String connectedRegistryName, ConnectedRegistryInner connectedRegistryCreateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (connectedRegistryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedRegistryName is required and cannot be null."));
        }
        if (connectedRegistryCreateParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedRegistryCreateParameters is required and cannot be null."));
        }
        connectedRegistryCreateParameters.validate();
        String apiVersion = "2025-11-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), "2025-11-01", this.client.getSubscriptionId(), resourceGroupName, registryName, connectedRegistryName, connectedRegistryCreateParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String registryName, String connectedRegistryName, ConnectedRegistryInner connectedRegistryCreateParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (connectedRegistryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedRegistryName is required and cannot be null."));
        }
        if (connectedRegistryCreateParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedRegistryCreateParameters is required and cannot be null."));
        }
        connectedRegistryCreateParameters.validate();
        String apiVersion = "2025-11-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), "2025-11-01", this.client.getSubscriptionId(), resourceGroupName, registryName, connectedRegistryName, connectedRegistryCreateParameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ConnectedRegistryInner>, ConnectedRegistryInner> beginCreateAsync(String resourceGroupName, String registryName, String connectedRegistryName, ConnectedRegistryInner connectedRegistryCreateParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, registryName, connectedRegistryName, connectedRegistryCreateParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ConnectedRegistryInner.class), (Type)((Object)ConnectedRegistryInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ConnectedRegistryInner>, ConnectedRegistryInner> beginCreateAsync(String resourceGroupName, String registryName, String connectedRegistryName, ConnectedRegistryInner connectedRegistryCreateParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, registryName, connectedRegistryName, connectedRegistryCreateParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ConnectedRegistryInner.class), (Type)((Object)ConnectedRegistryInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ConnectedRegistryInner>, ConnectedRegistryInner> beginCreate(String resourceGroupName, String registryName, String connectedRegistryName, ConnectedRegistryInner connectedRegistryCreateParameters) {
        return this.beginCreateAsync(resourceGroupName, registryName, connectedRegistryName, connectedRegistryCreateParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ConnectedRegistryInner>, ConnectedRegistryInner> beginCreate(String resourceGroupName, String registryName, String connectedRegistryName, ConnectedRegistryInner connectedRegistryCreateParameters, Context context) {
        return this.beginCreateAsync(resourceGroupName, registryName, connectedRegistryName, connectedRegistryCreateParameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConnectedRegistryInner> createAsync(String resourceGroupName, String registryName, String connectedRegistryName, ConnectedRegistryInner connectedRegistryCreateParameters) {
        return this.beginCreateAsync(resourceGroupName, registryName, connectedRegistryName, connectedRegistryCreateParameters).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ConnectedRegistryInner> createAsync(String resourceGroupName, String registryName, String connectedRegistryName, ConnectedRegistryInner connectedRegistryCreateParameters, Context context) {
        return this.beginCreateAsync(resourceGroupName, registryName, connectedRegistryName, connectedRegistryCreateParameters, context).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConnectedRegistryInner create(String resourceGroupName, String registryName, String connectedRegistryName, ConnectedRegistryInner connectedRegistryCreateParameters) {
        return (ConnectedRegistryInner)((Object)this.createAsync(resourceGroupName, registryName, connectedRegistryName, connectedRegistryCreateParameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConnectedRegistryInner create(String resourceGroupName, String registryName, String connectedRegistryName, ConnectedRegistryInner connectedRegistryCreateParameters, Context context) {
        return (ConnectedRegistryInner)((Object)this.createAsync(resourceGroupName, registryName, connectedRegistryName, connectedRegistryCreateParameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String registryName, String connectedRegistryName, ConnectedRegistryUpdateParameters connectedRegistryUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (connectedRegistryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedRegistryName is required and cannot be null."));
        }
        if (connectedRegistryUpdateParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedRegistryUpdateParameters is required and cannot be null."));
        }
        connectedRegistryUpdateParameters.validate();
        String apiVersion = "2025-11-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), "2025-11-01", this.client.getSubscriptionId(), resourceGroupName, registryName, connectedRegistryName, connectedRegistryUpdateParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String registryName, String connectedRegistryName, ConnectedRegistryUpdateParameters connectedRegistryUpdateParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (connectedRegistryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedRegistryName is required and cannot be null."));
        }
        if (connectedRegistryUpdateParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedRegistryUpdateParameters is required and cannot be null."));
        }
        connectedRegistryUpdateParameters.validate();
        String apiVersion = "2025-11-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), "2025-11-01", this.client.getSubscriptionId(), resourceGroupName, registryName, connectedRegistryName, connectedRegistryUpdateParameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ConnectedRegistryInner>, ConnectedRegistryInner> beginUpdateAsync(String resourceGroupName, String registryName, String connectedRegistryName, ConnectedRegistryUpdateParameters connectedRegistryUpdateParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, registryName, connectedRegistryName, connectedRegistryUpdateParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ConnectedRegistryInner.class), (Type)((Object)ConnectedRegistryInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ConnectedRegistryInner>, ConnectedRegistryInner> beginUpdateAsync(String resourceGroupName, String registryName, String connectedRegistryName, ConnectedRegistryUpdateParameters connectedRegistryUpdateParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, registryName, connectedRegistryName, connectedRegistryUpdateParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ConnectedRegistryInner.class), (Type)((Object)ConnectedRegistryInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ConnectedRegistryInner>, ConnectedRegistryInner> beginUpdate(String resourceGroupName, String registryName, String connectedRegistryName, ConnectedRegistryUpdateParameters connectedRegistryUpdateParameters) {
        return this.beginUpdateAsync(resourceGroupName, registryName, connectedRegistryName, connectedRegistryUpdateParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ConnectedRegistryInner>, ConnectedRegistryInner> beginUpdate(String resourceGroupName, String registryName, String connectedRegistryName, ConnectedRegistryUpdateParameters connectedRegistryUpdateParameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, registryName, connectedRegistryName, connectedRegistryUpdateParameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConnectedRegistryInner> updateAsync(String resourceGroupName, String registryName, String connectedRegistryName, ConnectedRegistryUpdateParameters connectedRegistryUpdateParameters) {
        return this.beginUpdateAsync(resourceGroupName, registryName, connectedRegistryName, connectedRegistryUpdateParameters).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ConnectedRegistryInner> updateAsync(String resourceGroupName, String registryName, String connectedRegistryName, ConnectedRegistryUpdateParameters connectedRegistryUpdateParameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, registryName, connectedRegistryName, connectedRegistryUpdateParameters, context).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConnectedRegistryInner update(String resourceGroupName, String registryName, String connectedRegistryName, ConnectedRegistryUpdateParameters connectedRegistryUpdateParameters) {
        return (ConnectedRegistryInner)((Object)this.updateAsync(resourceGroupName, registryName, connectedRegistryName, connectedRegistryUpdateParameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConnectedRegistryInner update(String resourceGroupName, String registryName, String connectedRegistryName, ConnectedRegistryUpdateParameters connectedRegistryUpdateParameters, Context context) {
        return (ConnectedRegistryInner)((Object)this.updateAsync(resourceGroupName, registryName, connectedRegistryName, connectedRegistryUpdateParameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String registryName, String connectedRegistryName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (connectedRegistryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedRegistryName is required and cannot be null."));
        }
        String apiVersion = "2025-11-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), "2025-11-01", this.client.getSubscriptionId(), resourceGroupName, registryName, connectedRegistryName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String registryName, String connectedRegistryName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (connectedRegistryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedRegistryName is required and cannot be null."));
        }
        String apiVersion = "2025-11-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), "2025-11-01", this.client.getSubscriptionId(), resourceGroupName, registryName, connectedRegistryName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String registryName, String connectedRegistryName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, registryName, connectedRegistryName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String registryName, String connectedRegistryName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, registryName, connectedRegistryName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String registryName, String connectedRegistryName) {
        return this.beginDeleteAsync(resourceGroupName, registryName, connectedRegistryName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String registryName, String connectedRegistryName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, registryName, connectedRegistryName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String registryName, String connectedRegistryName) {
        return this.beginDeleteAsync(resourceGroupName, registryName, connectedRegistryName).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String registryName, String connectedRegistryName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, registryName, connectedRegistryName, context).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String registryName, String connectedRegistryName) {
        this.deleteAsync(resourceGroupName, registryName, connectedRegistryName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String registryName, String connectedRegistryName, Context context) {
        this.deleteAsync(resourceGroupName, registryName, connectedRegistryName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deactivateWithResponseAsync(String resourceGroupName, String registryName, String connectedRegistryName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (connectedRegistryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedRegistryName is required and cannot be null."));
        }
        String apiVersion = "2025-11-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deactivate(this.client.getEndpoint(), "2025-11-01", this.client.getSubscriptionId(), resourceGroupName, registryName, connectedRegistryName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deactivateWithResponseAsync(String resourceGroupName, String registryName, String connectedRegistryName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (connectedRegistryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedRegistryName is required and cannot be null."));
        }
        String apiVersion = "2025-11-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deactivate(this.client.getEndpoint(), "2025-11-01", this.client.getSubscriptionId(), resourceGroupName, registryName, connectedRegistryName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeactivateAsync(String resourceGroupName, String registryName, String connectedRegistryName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deactivateWithResponseAsync(resourceGroupName, registryName, connectedRegistryName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeactivateAsync(String resourceGroupName, String registryName, String connectedRegistryName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deactivateWithResponseAsync(resourceGroupName, registryName, connectedRegistryName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeactivate(String resourceGroupName, String registryName, String connectedRegistryName) {
        return this.beginDeactivateAsync(resourceGroupName, registryName, connectedRegistryName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeactivate(String resourceGroupName, String registryName, String connectedRegistryName, Context context) {
        return this.beginDeactivateAsync(resourceGroupName, registryName, connectedRegistryName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deactivateAsync(String resourceGroupName, String registryName, String connectedRegistryName) {
        return this.beginDeactivateAsync(resourceGroupName, registryName, connectedRegistryName).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deactivateAsync(String resourceGroupName, String registryName, String connectedRegistryName, Context context) {
        return this.beginDeactivateAsync(resourceGroupName, registryName, connectedRegistryName, context).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deactivate(String resourceGroupName, String registryName, String connectedRegistryName) {
        this.deactivateAsync(resourceGroupName, registryName, connectedRegistryName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deactivate(String resourceGroupName, String registryName, String connectedRegistryName, Context context) {
        this.deactivateAsync(resourceGroupName, registryName, connectedRegistryName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ConnectedRegistryInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConnectedRegistryListResult)res.getValue()).value(), ((ConnectedRegistryListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ConnectedRegistryInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConnectedRegistryListResult)res.getValue()).value(), ((ConnectedRegistryListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ContainerRegistryManagementClientConnectedRegistries")
    public static interface ConnectedRegistriesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/connectedRegistries")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConnectedRegistryListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="registryName") String var5, @QueryParam(value="$filter") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/connectedRegistries/{connectedRegistryName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConnectedRegistryInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="registryName") String var5, @PathParam(value="connectedRegistryName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/connectedRegistries/{connectedRegistryName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="registryName") String var5, @PathParam(value="connectedRegistryName") String var6, @BodyParam(value="application/json") ConnectedRegistryInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/connectedRegistries/{connectedRegistryName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="registryName") String var5, @PathParam(value="connectedRegistryName") String var6, @BodyParam(value="application/json") ConnectedRegistryUpdateParameters var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/connectedRegistries/{connectedRegistryName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="registryName") String var5, @PathParam(value="connectedRegistryName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/connectedRegistries/{connectedRegistryName}/deactivate")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> deactivate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="registryName") String var5, @PathParam(value="connectedRegistryName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConnectedRegistryListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

