/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.OS;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import java.io.IOException;

public final class AgentPoolProperties
implements JsonSerializable<AgentPoolProperties> {
    private Integer count;
    private String tier;
    private OS os;
    private String virtualNetworkSubnetResourceId;
    private ProvisioningState provisioningState;

    public Integer count() {
        return this.count;
    }

    public AgentPoolProperties withCount(Integer count) {
        this.count = count;
        return this;
    }

    public String tier() {
        return this.tier;
    }

    public AgentPoolProperties withTier(String tier) {
        this.tier = tier;
        return this;
    }

    public OS os() {
        return this.os;
    }

    public AgentPoolProperties withOs(OS os) {
        this.os = os;
        return this;
    }

    public String virtualNetworkSubnetResourceId() {
        return this.virtualNetworkSubnetResourceId;
    }

    public AgentPoolProperties withVirtualNetworkSubnetResourceId(String virtualNetworkSubnetResourceId) {
        this.virtualNetworkSubnetResourceId = virtualNetworkSubnetResourceId;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("count", (Number)this.count);
        jsonWriter.writeStringField("tier", this.tier);
        jsonWriter.writeStringField("os", this.os == null ? null : this.os.toString());
        jsonWriter.writeStringField("virtualNetworkSubnetResourceId", this.virtualNetworkSubnetResourceId);
        return jsonWriter.writeEndObject();
    }

    public static AgentPoolProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AgentPoolProperties)jsonReader.readObject(reader -> {
            AgentPoolProperties deserializedAgentPoolProperties = new AgentPoolProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("count".equals(fieldName)) {
                    deserializedAgentPoolProperties.count = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("tier".equals(fieldName)) {
                    deserializedAgentPoolProperties.tier = reader.getString();
                    continue;
                }
                if ("os".equals(fieldName)) {
                    deserializedAgentPoolProperties.os = OS.fromString(reader.getString());
                    continue;
                }
                if ("virtualNetworkSubnetResourceId".equals(fieldName)) {
                    deserializedAgentPoolProperties.virtualNetworkSubnetResourceId = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedAgentPoolProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAgentPoolProperties;
        });
    }
}

