/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class SetValue
implements JsonSerializable<SetValue> {
    private String name;
    private String value;
    private Boolean isSecret;
    private static final ClientLogger LOGGER = new ClientLogger(SetValue.class);

    public String name() {
        return this.name;
    }

    public SetValue withName(String name) {
        this.name = name;
        return this;
    }

    public String value() {
        return this.value;
    }

    public SetValue withValue(String value) {
        this.value = value;
        return this;
    }

    public Boolean isSecret() {
        return this.isSecret;
    }

    public SetValue withIsSecret(Boolean isSecret) {
        this.isSecret = isSecret;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model SetValue"));
        }
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model SetValue"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeBooleanField("isSecret", this.isSecret);
        return jsonWriter.writeEndObject();
    }

    public static SetValue fromJson(JsonReader jsonReader) throws IOException {
        return (SetValue)jsonReader.readObject(reader -> {
            SetValue deserializedSetValue = new SetValue();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSetValue.name = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedSetValue.value = reader.getString();
                    continue;
                }
                if ("isSecret".equals(fieldName)) {
                    deserializedSetValue.isSecret = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSetValue;
        });
    }
}

