/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.containerregistry.fluent.models.RegistryProperties;
import com.azure.resourcemanager.containerregistry.models.AutoGeneratedDomainNameLabelScope;
import com.azure.resourcemanager.containerregistry.models.EncryptionProperty;
import com.azure.resourcemanager.containerregistry.models.IdentityProperties;
import com.azure.resourcemanager.containerregistry.models.NetworkRuleBypassOptions;
import com.azure.resourcemanager.containerregistry.models.NetworkRuleSet;
import com.azure.resourcemanager.containerregistry.models.Policies;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.azure.resourcemanager.containerregistry.models.PublicNetworkAccess;
import com.azure.resourcemanager.containerregistry.models.RoleAssignmentMode;
import com.azure.resourcemanager.containerregistry.models.Sku;
import com.azure.resourcemanager.containerregistry.models.Status;
import com.azure.resourcemanager.containerregistry.models.ZoneRedundancy;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class RegistryInner
extends Resource {
    private RegistryProperties innerProperties;
    private Sku sku;
    private IdentityProperties identity;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(RegistryInner.class);

    private RegistryProperties innerProperties() {
        return this.innerProperties;
    }

    public Sku sku() {
        return this.sku;
    }

    public RegistryInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public IdentityProperties identity() {
        return this.identity;
    }

    public RegistryInner withIdentity(IdentityProperties identity) {
        this.identity = identity;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public RegistryInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public RegistryInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String loginServer() {
        return this.innerProperties() == null ? null : this.innerProperties().loginServer();
    }

    public OffsetDateTime creationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().creationDate();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public Status status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public Boolean adminUserEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().adminUserEnabled();
    }

    public RegistryInner withAdminUserEnabled(Boolean adminUserEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryProperties();
        }
        this.innerProperties().withAdminUserEnabled(adminUserEnabled);
        return this;
    }

    public NetworkRuleSet networkRuleSet() {
        return this.innerProperties() == null ? null : this.innerProperties().networkRuleSet();
    }

    public RegistryInner withNetworkRuleSet(NetworkRuleSet networkRuleSet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryProperties();
        }
        this.innerProperties().withNetworkRuleSet(networkRuleSet);
        return this;
    }

    public Policies policies() {
        return this.innerProperties() == null ? null : this.innerProperties().policies();
    }

    public RegistryInner withPolicies(Policies policies) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryProperties();
        }
        this.innerProperties().withPolicies(policies);
        return this;
    }

    public EncryptionProperty encryption() {
        return this.innerProperties() == null ? null : this.innerProperties().encryption();
    }

    public RegistryInner withEncryption(EncryptionProperty encryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryProperties();
        }
        this.innerProperties().withEncryption(encryption);
        return this;
    }

    public Boolean dataEndpointEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().dataEndpointEnabled();
    }

    public RegistryInner withDataEndpointEnabled(Boolean dataEndpointEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryProperties();
        }
        this.innerProperties().withDataEndpointEnabled(dataEndpointEnabled);
        return this;
    }

    public List<String> dataEndpointHostNames() {
        return this.innerProperties() == null ? null : this.innerProperties().dataEndpointHostNames();
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public RegistryInner withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public NetworkRuleBypassOptions networkRuleBypassOptions() {
        return this.innerProperties() == null ? null : this.innerProperties().networkRuleBypassOptions();
    }

    public RegistryInner withNetworkRuleBypassOptions(NetworkRuleBypassOptions networkRuleBypassOptions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryProperties();
        }
        this.innerProperties().withNetworkRuleBypassOptions(networkRuleBypassOptions);
        return this;
    }

    public Boolean networkRuleBypassAllowedForTasks() {
        return this.innerProperties() == null ? null : this.innerProperties().networkRuleBypassAllowedForTasks();
    }

    public RegistryInner withNetworkRuleBypassAllowedForTasks(Boolean networkRuleBypassAllowedForTasks) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryProperties();
        }
        this.innerProperties().withNetworkRuleBypassAllowedForTasks(networkRuleBypassAllowedForTasks);
        return this;
    }

    public ZoneRedundancy zoneRedundancy() {
        return this.innerProperties() == null ? null : this.innerProperties().zoneRedundancy();
    }

    public RegistryInner withZoneRedundancy(ZoneRedundancy zoneRedundancy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryProperties();
        }
        this.innerProperties().withZoneRedundancy(zoneRedundancy);
        return this;
    }

    public Boolean anonymousPullEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().anonymousPullEnabled();
    }

    public RegistryInner withAnonymousPullEnabled(Boolean anonymousPullEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryProperties();
        }
        this.innerProperties().withAnonymousPullEnabled(anonymousPullEnabled);
        return this;
    }

    public AutoGeneratedDomainNameLabelScope autoGeneratedDomainNameLabelScope() {
        return this.innerProperties() == null ? null : this.innerProperties().autoGeneratedDomainNameLabelScope();
    }

    public RegistryInner withAutoGeneratedDomainNameLabelScope(AutoGeneratedDomainNameLabelScope autoGeneratedDomainNameLabelScope) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryProperties();
        }
        this.innerProperties().withAutoGeneratedDomainNameLabelScope(autoGeneratedDomainNameLabelScope);
        return this;
    }

    public RoleAssignmentMode roleAssignmentMode() {
        return this.innerProperties() == null ? null : this.innerProperties().roleAssignmentMode();
    }

    public RegistryInner withRoleAssignmentMode(RoleAssignmentMode roleAssignmentMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryProperties();
        }
        this.innerProperties().withRoleAssignmentMode(roleAssignmentMode);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.sku() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sku in model RegistryInner"));
        }
        this.sku().validate();
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static RegistryInner fromJson(JsonReader jsonReader) throws IOException {
        return (RegistryInner)((Object)jsonReader.readObject(reader -> {
            RegistryInner deserializedRegistryInner = new RegistryInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRegistryInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRegistryInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRegistryInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedRegistryInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedRegistryInner.withTags(tags);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedRegistryInner.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedRegistryInner.innerProperties = RegistryProperties.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedRegistryInner.identity = IdentityProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedRegistryInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRegistryInner;
        }));
    }
}

