/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.azure.resourcemanager.containerregistry.models.Status;
import com.azure.resourcemanager.containerregistry.models.ZoneRedundancy;
import java.io.IOException;

public final class ReplicationProperties
implements JsonSerializable<ReplicationProperties> {
    private ProvisioningState provisioningState;
    private Status status;
    private Boolean regionEndpointEnabled;
    private ZoneRedundancy zoneRedundancy;

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Status status() {
        return this.status;
    }

    public Boolean regionEndpointEnabled() {
        return this.regionEndpointEnabled;
    }

    public ReplicationProperties withRegionEndpointEnabled(Boolean regionEndpointEnabled) {
        this.regionEndpointEnabled = regionEndpointEnabled;
        return this;
    }

    public ZoneRedundancy zoneRedundancy() {
        return this.zoneRedundancy;
    }

    public ReplicationProperties withZoneRedundancy(ZoneRedundancy zoneRedundancy) {
        this.zoneRedundancy = zoneRedundancy;
        return this;
    }

    public void validate() {
        if (this.status() != null) {
            this.status().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("regionEndpointEnabled", this.regionEndpointEnabled);
        jsonWriter.writeStringField("zoneRedundancy", this.zoneRedundancy == null ? null : this.zoneRedundancy.toString());
        return jsonWriter.writeEndObject();
    }

    public static ReplicationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ReplicationProperties)jsonReader.readObject(reader -> {
            ReplicationProperties deserializedReplicationProperties = new ReplicationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedReplicationProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedReplicationProperties.status = Status.fromJson(reader);
                    continue;
                }
                if ("regionEndpointEnabled".equals(fieldName)) {
                    deserializedReplicationProperties.regionEndpointEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("zoneRedundancy".equals(fieldName)) {
                    deserializedReplicationProperties.zoneRedundancy = ZoneRedundancy.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReplicationProperties;
        });
    }
}

