/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.SecretObjectType;
import java.io.IOException;

public final class SecretObject
implements JsonSerializable<SecretObject> {
    private String value;
    private SecretObjectType type;

    public String value() {
        return this.value;
    }

    public SecretObject withValue(String value) {
        this.value = value;
        return this;
    }

    public SecretObjectType type() {
        return this.type;
    }

    public SecretObject withType(SecretObjectType type) {
        this.type = type;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static SecretObject fromJson(JsonReader jsonReader) throws IOException {
        return (SecretObject)jsonReader.readObject(reader -> {
            SecretObject deserializedSecretObject = new SecretObject();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    deserializedSecretObject.value = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSecretObject.type = SecretObjectType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecretObject;
        });
    }
}

