/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.fluent.models.ConnectedRegistryProperties;
import com.azure.resourcemanager.containerregistry.models.ActivationProperties;
import com.azure.resourcemanager.containerregistry.models.ConnectedRegistryMode;
import com.azure.resourcemanager.containerregistry.models.ConnectionState;
import com.azure.resourcemanager.containerregistry.models.GarbageCollectionProperties;
import com.azure.resourcemanager.containerregistry.models.LoggingProperties;
import com.azure.resourcemanager.containerregistry.models.LoginServerProperties;
import com.azure.resourcemanager.containerregistry.models.ParentProperties;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.azure.resourcemanager.containerregistry.models.StatusDetailProperties;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class ConnectedRegistryInner
extends ProxyResource {
    private ConnectedRegistryProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private ConnectedRegistryProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public ConnectedRegistryMode mode() {
        return this.innerProperties() == null ? null : this.innerProperties().mode();
    }

    public ConnectedRegistryInner withMode(ConnectedRegistryMode mode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectedRegistryProperties();
        }
        this.innerProperties().withMode(mode);
        return this;
    }

    public String version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    public ConnectionState connectionState() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionState();
    }

    public OffsetDateTime lastActivityTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastActivityTime();
    }

    public ActivationProperties activation() {
        return this.innerProperties() == null ? null : this.innerProperties().activation();
    }

    public ParentProperties parent() {
        return this.innerProperties() == null ? null : this.innerProperties().parent();
    }

    public ConnectedRegistryInner withParent(ParentProperties parent) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectedRegistryProperties();
        }
        this.innerProperties().withParent(parent);
        return this;
    }

    public List<String> clientTokenIds() {
        return this.innerProperties() == null ? null : this.innerProperties().clientTokenIds();
    }

    public ConnectedRegistryInner withClientTokenIds(List<String> clientTokenIds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectedRegistryProperties();
        }
        this.innerProperties().withClientTokenIds(clientTokenIds);
        return this;
    }

    public LoginServerProperties loginServer() {
        return this.innerProperties() == null ? null : this.innerProperties().loginServer();
    }

    public ConnectedRegistryInner withLoginServer(LoginServerProperties loginServer) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectedRegistryProperties();
        }
        this.innerProperties().withLoginServer(loginServer);
        return this;
    }

    public LoggingProperties logging() {
        return this.innerProperties() == null ? null : this.innerProperties().logging();
    }

    public ConnectedRegistryInner withLogging(LoggingProperties logging) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectedRegistryProperties();
        }
        this.innerProperties().withLogging(logging);
        return this;
    }

    public List<StatusDetailProperties> statusDetails() {
        return this.innerProperties() == null ? null : this.innerProperties().statusDetails();
    }

    public List<String> notificationsList() {
        return this.innerProperties() == null ? null : this.innerProperties().notificationsList();
    }

    public ConnectedRegistryInner withNotificationsList(List<String> notificationsList) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectedRegistryProperties();
        }
        this.innerProperties().withNotificationsList(notificationsList);
        return this;
    }

    public GarbageCollectionProperties garbageCollection() {
        return this.innerProperties() == null ? null : this.innerProperties().garbageCollection();
    }

    public ConnectedRegistryInner withGarbageCollection(GarbageCollectionProperties garbageCollection) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectedRegistryProperties();
        }
        this.innerProperties().withGarbageCollection(garbageCollection);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ConnectedRegistryInner fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectedRegistryInner)((Object)jsonReader.readObject(reader -> {
            ConnectedRegistryInner deserializedConnectedRegistryInner = new ConnectedRegistryInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedConnectedRegistryInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedConnectedRegistryInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedConnectedRegistryInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedConnectedRegistryInner.innerProperties = ConnectedRegistryProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedConnectedRegistryInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectedRegistryInner;
        }));
    }
}

