/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.fluent.models.RegistryPropertiesUpdateParameters;
import com.azure.resourcemanager.containerregistry.models.EncryptionProperty;
import com.azure.resourcemanager.containerregistry.models.IdentityProperties;
import com.azure.resourcemanager.containerregistry.models.NetworkRuleBypassOptions;
import com.azure.resourcemanager.containerregistry.models.NetworkRuleSet;
import com.azure.resourcemanager.containerregistry.models.Policies;
import com.azure.resourcemanager.containerregistry.models.PublicNetworkAccess;
import com.azure.resourcemanager.containerregistry.models.Sku;
import java.io.IOException;
import java.util.Map;

public final class RegistryUpdateParameters
implements JsonSerializable<RegistryUpdateParameters> {
    private IdentityProperties identity;
    private Map<String, String> tags;
    private Sku sku;
    private RegistryPropertiesUpdateParameters innerProperties;

    public IdentityProperties identity() {
        return this.identity;
    }

    public RegistryUpdateParameters withIdentity(IdentityProperties identity) {
        this.identity = identity;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public RegistryUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Sku sku() {
        return this.sku;
    }

    public RegistryUpdateParameters withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    private RegistryPropertiesUpdateParameters innerProperties() {
        return this.innerProperties;
    }

    public Boolean adminUserEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().adminUserEnabled();
    }

    public RegistryUpdateParameters withAdminUserEnabled(Boolean adminUserEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryPropertiesUpdateParameters();
        }
        this.innerProperties().withAdminUserEnabled(adminUserEnabled);
        return this;
    }

    public NetworkRuleSet networkRuleSet() {
        return this.innerProperties() == null ? null : this.innerProperties().networkRuleSet();
    }

    public RegistryUpdateParameters withNetworkRuleSet(NetworkRuleSet networkRuleSet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryPropertiesUpdateParameters();
        }
        this.innerProperties().withNetworkRuleSet(networkRuleSet);
        return this;
    }

    public Policies policies() {
        return this.innerProperties() == null ? null : this.innerProperties().policies();
    }

    public RegistryUpdateParameters withPolicies(Policies policies) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryPropertiesUpdateParameters();
        }
        this.innerProperties().withPolicies(policies);
        return this;
    }

    public EncryptionProperty encryption() {
        return this.innerProperties() == null ? null : this.innerProperties().encryption();
    }

    public RegistryUpdateParameters withEncryption(EncryptionProperty encryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryPropertiesUpdateParameters();
        }
        this.innerProperties().withEncryption(encryption);
        return this;
    }

    public Boolean dataEndpointEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().dataEndpointEnabled();
    }

    public RegistryUpdateParameters withDataEndpointEnabled(Boolean dataEndpointEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryPropertiesUpdateParameters();
        }
        this.innerProperties().withDataEndpointEnabled(dataEndpointEnabled);
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public RegistryUpdateParameters withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryPropertiesUpdateParameters();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public NetworkRuleBypassOptions networkRuleBypassOptions() {
        return this.innerProperties() == null ? null : this.innerProperties().networkRuleBypassOptions();
    }

    public RegistryUpdateParameters withNetworkRuleBypassOptions(NetworkRuleBypassOptions networkRuleBypassOptions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryPropertiesUpdateParameters();
        }
        this.innerProperties().withNetworkRuleBypassOptions(networkRuleBypassOptions);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static RegistryUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (RegistryUpdateParameters)jsonReader.readObject(reader -> {
            RegistryUpdateParameters deserializedRegistryUpdateParameters = new RegistryUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("identity".equals(fieldName)) {
                    deserializedRegistryUpdateParameters.identity = IdentityProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedRegistryUpdateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedRegistryUpdateParameters.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedRegistryUpdateParameters.innerProperties = RegistryPropertiesUpdateParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRegistryUpdateParameters;
        });
    }
}

