/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.containerregistry.fluent.CredentialSetsClient;
import com.azure.resourcemanager.containerregistry.fluent.models.CredentialSetInner;
import com.azure.resourcemanager.containerregistry.implementation.ContainerRegistryManagementClientImpl;
import com.azure.resourcemanager.containerregistry.models.CredentialSetListResult;
import com.azure.resourcemanager.containerregistry.models.CredentialSetUpdateParameters;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class CredentialSetsClientImpl
implements CredentialSetsClient {
    private final CredentialSetsService service;
    private final ContainerRegistryManagementClientImpl client;

    CredentialSetsClientImpl(ContainerRegistryManagementClientImpl client) {
        this.service = (CredentialSetsService)RestProxy.create(CredentialSetsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CredentialSetInner>> listSinglePageAsync(String resourceGroupName, String registryName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        String apiVersion = "2023-07-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2023-07-01", this.client.getSubscriptionId(), resourceGroupName, registryName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CredentialSetListResult)res.getValue()).value(), ((CredentialSetListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CredentialSetInner>> listSinglePageAsync(String resourceGroupName, String registryName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        String apiVersion = "2023-07-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2023-07-01", this.client.getSubscriptionId(), resourceGroupName, registryName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CredentialSetListResult)res.getValue()).value(), ((CredentialSetListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CredentialSetInner> listAsync(String resourceGroupName, String registryName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, registryName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<CredentialSetInner> listAsync(String resourceGroupName, String registryName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, registryName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CredentialSetInner> list(String resourceGroupName, String registryName) {
        return new PagedIterable(this.listAsync(resourceGroupName, registryName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CredentialSetInner> list(String resourceGroupName, String registryName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, registryName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CredentialSetInner>> getWithResponseAsync(String resourceGroupName, String registryName, String credentialSetName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (credentialSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter credentialSetName is required and cannot be null."));
        }
        String apiVersion = "2023-07-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2023-07-01", this.client.getSubscriptionId(), resourceGroupName, registryName, credentialSetName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CredentialSetInner>> getWithResponseAsync(String resourceGroupName, String registryName, String credentialSetName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (credentialSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter credentialSetName is required and cannot be null."));
        }
        String apiVersion = "2023-07-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), "2023-07-01", this.client.getSubscriptionId(), resourceGroupName, registryName, credentialSetName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CredentialSetInner> getAsync(String resourceGroupName, String registryName, String credentialSetName) {
        return this.getWithResponseAsync(resourceGroupName, registryName, credentialSetName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((CredentialSetInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CredentialSetInner> getWithResponse(String resourceGroupName, String registryName, String credentialSetName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, registryName, credentialSetName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CredentialSetInner get(String resourceGroupName, String registryName, String credentialSetName) {
        return (CredentialSetInner)((Object)this.getWithResponse(resourceGroupName, registryName, credentialSetName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String registryName, String credentialSetName, CredentialSetInner credentialSetCreateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (credentialSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter credentialSetName is required and cannot be null."));
        }
        if (credentialSetCreateParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter credentialSetCreateParameters is required and cannot be null."));
        }
        credentialSetCreateParameters.validate();
        String apiVersion = "2023-07-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), "2023-07-01", this.client.getSubscriptionId(), resourceGroupName, registryName, credentialSetName, credentialSetCreateParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String registryName, String credentialSetName, CredentialSetInner credentialSetCreateParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (credentialSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter credentialSetName is required and cannot be null."));
        }
        if (credentialSetCreateParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter credentialSetCreateParameters is required and cannot be null."));
        }
        credentialSetCreateParameters.validate();
        String apiVersion = "2023-07-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), "2023-07-01", this.client.getSubscriptionId(), resourceGroupName, registryName, credentialSetName, credentialSetCreateParameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<CredentialSetInner>, CredentialSetInner> beginCreateAsync(String resourceGroupName, String registryName, String credentialSetName, CredentialSetInner credentialSetCreateParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, registryName, credentialSetName, credentialSetCreateParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)CredentialSetInner.class), (Type)((Object)CredentialSetInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CredentialSetInner>, CredentialSetInner> beginCreateAsync(String resourceGroupName, String registryName, String credentialSetName, CredentialSetInner credentialSetCreateParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, registryName, credentialSetName, credentialSetCreateParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)CredentialSetInner.class), (Type)((Object)CredentialSetInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CredentialSetInner>, CredentialSetInner> beginCreate(String resourceGroupName, String registryName, String credentialSetName, CredentialSetInner credentialSetCreateParameters) {
        return this.beginCreateAsync(resourceGroupName, registryName, credentialSetName, credentialSetCreateParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CredentialSetInner>, CredentialSetInner> beginCreate(String resourceGroupName, String registryName, String credentialSetName, CredentialSetInner credentialSetCreateParameters, Context context) {
        return this.beginCreateAsync(resourceGroupName, registryName, credentialSetName, credentialSetCreateParameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CredentialSetInner> createAsync(String resourceGroupName, String registryName, String credentialSetName, CredentialSetInner credentialSetCreateParameters) {
        return this.beginCreateAsync(resourceGroupName, registryName, credentialSetName, credentialSetCreateParameters).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CredentialSetInner> createAsync(String resourceGroupName, String registryName, String credentialSetName, CredentialSetInner credentialSetCreateParameters, Context context) {
        return this.beginCreateAsync(resourceGroupName, registryName, credentialSetName, credentialSetCreateParameters, context).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CredentialSetInner create(String resourceGroupName, String registryName, String credentialSetName, CredentialSetInner credentialSetCreateParameters) {
        return (CredentialSetInner)((Object)this.createAsync(resourceGroupName, registryName, credentialSetName, credentialSetCreateParameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CredentialSetInner create(String resourceGroupName, String registryName, String credentialSetName, CredentialSetInner credentialSetCreateParameters, Context context) {
        return (CredentialSetInner)((Object)this.createAsync(resourceGroupName, registryName, credentialSetName, credentialSetCreateParameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String registryName, String credentialSetName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (credentialSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter credentialSetName is required and cannot be null."));
        }
        String apiVersion = "2023-07-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), "2023-07-01", this.client.getSubscriptionId(), resourceGroupName, registryName, credentialSetName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String registryName, String credentialSetName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (credentialSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter credentialSetName is required and cannot be null."));
        }
        String apiVersion = "2023-07-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), "2023-07-01", this.client.getSubscriptionId(), resourceGroupName, registryName, credentialSetName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String registryName, String credentialSetName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, registryName, credentialSetName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String registryName, String credentialSetName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, registryName, credentialSetName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String registryName, String credentialSetName) {
        return this.beginDeleteAsync(resourceGroupName, registryName, credentialSetName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String registryName, String credentialSetName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, registryName, credentialSetName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String registryName, String credentialSetName) {
        return this.beginDeleteAsync(resourceGroupName, registryName, credentialSetName).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String registryName, String credentialSetName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, registryName, credentialSetName, context).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String registryName, String credentialSetName) {
        this.deleteAsync(resourceGroupName, registryName, credentialSetName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String registryName, String credentialSetName, Context context) {
        this.deleteAsync(resourceGroupName, registryName, credentialSetName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String registryName, String credentialSetName, CredentialSetUpdateParameters credentialSetUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (credentialSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter credentialSetName is required and cannot be null."));
        }
        if (credentialSetUpdateParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter credentialSetUpdateParameters is required and cannot be null."));
        }
        credentialSetUpdateParameters.validate();
        String apiVersion = "2023-07-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), "2023-07-01", this.client.getSubscriptionId(), resourceGroupName, registryName, credentialSetName, credentialSetUpdateParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String registryName, String credentialSetName, CredentialSetUpdateParameters credentialSetUpdateParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (credentialSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter credentialSetName is required and cannot be null."));
        }
        if (credentialSetUpdateParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter credentialSetUpdateParameters is required and cannot be null."));
        }
        credentialSetUpdateParameters.validate();
        String apiVersion = "2023-07-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), "2023-07-01", this.client.getSubscriptionId(), resourceGroupName, registryName, credentialSetName, credentialSetUpdateParameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<CredentialSetInner>, CredentialSetInner> beginUpdateAsync(String resourceGroupName, String registryName, String credentialSetName, CredentialSetUpdateParameters credentialSetUpdateParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, registryName, credentialSetName, credentialSetUpdateParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)CredentialSetInner.class), (Type)((Object)CredentialSetInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CredentialSetInner>, CredentialSetInner> beginUpdateAsync(String resourceGroupName, String registryName, String credentialSetName, CredentialSetUpdateParameters credentialSetUpdateParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, registryName, credentialSetName, credentialSetUpdateParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)CredentialSetInner.class), (Type)((Object)CredentialSetInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CredentialSetInner>, CredentialSetInner> beginUpdate(String resourceGroupName, String registryName, String credentialSetName, CredentialSetUpdateParameters credentialSetUpdateParameters) {
        return this.beginUpdateAsync(resourceGroupName, registryName, credentialSetName, credentialSetUpdateParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CredentialSetInner>, CredentialSetInner> beginUpdate(String resourceGroupName, String registryName, String credentialSetName, CredentialSetUpdateParameters credentialSetUpdateParameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, registryName, credentialSetName, credentialSetUpdateParameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CredentialSetInner> updateAsync(String resourceGroupName, String registryName, String credentialSetName, CredentialSetUpdateParameters credentialSetUpdateParameters) {
        return this.beginUpdateAsync(resourceGroupName, registryName, credentialSetName, credentialSetUpdateParameters).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CredentialSetInner> updateAsync(String resourceGroupName, String registryName, String credentialSetName, CredentialSetUpdateParameters credentialSetUpdateParameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, registryName, credentialSetName, credentialSetUpdateParameters, context).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CredentialSetInner update(String resourceGroupName, String registryName, String credentialSetName, CredentialSetUpdateParameters credentialSetUpdateParameters) {
        return (CredentialSetInner)((Object)this.updateAsync(resourceGroupName, registryName, credentialSetName, credentialSetUpdateParameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CredentialSetInner update(String resourceGroupName, String registryName, String credentialSetName, CredentialSetUpdateParameters credentialSetUpdateParameters, Context context) {
        return (CredentialSetInner)((Object)this.updateAsync(resourceGroupName, registryName, credentialSetName, credentialSetUpdateParameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CredentialSetInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CredentialSetListResult)res.getValue()).value(), ((CredentialSetListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CredentialSetInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CredentialSetListResult)res.getValue()).value(), ((CredentialSetListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ContainerRegistryMan")
    public static interface CredentialSetsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/credentialSets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CredentialSetListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="registryName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/credentialSets/{credentialSetName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CredentialSetInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="registryName") String var5, @PathParam(value="credentialSetName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/credentialSets/{credentialSetName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="registryName") String var5, @PathParam(value="credentialSetName") String var6, @BodyParam(value="application/json") CredentialSetInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/credentialSets/{credentialSetName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="registryName") String var5, @PathParam(value="credentialSetName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/credentialSets/{credentialSetName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="registryName") String var5, @PathParam(value="credentialSetName") String var6, @BodyParam(value="application/json") CredentialSetUpdateParameters var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CredentialSetListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

