/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.fluent.models.CredentialSetProperties;
import com.azure.resourcemanager.containerregistry.models.AuthCredential;
import com.azure.resourcemanager.containerregistry.models.IdentityProperties;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class CredentialSetInner
extends ProxyResource {
    private IdentityProperties identity;
    private CredentialSetProperties innerProperties;
    private SystemData systemData;
    private String id;
    private String name;
    private String type;

    public IdentityProperties identity() {
        return this.identity;
    }

    public CredentialSetInner withIdentity(IdentityProperties identity) {
        this.identity = identity;
        return this;
    }

    private CredentialSetProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public String loginServer() {
        return this.innerProperties() == null ? null : this.innerProperties().loginServer();
    }

    public CredentialSetInner withLoginServer(String loginServer) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CredentialSetProperties();
        }
        this.innerProperties().withLoginServer(loginServer);
        return this;
    }

    public List<AuthCredential> authCredentials() {
        return this.innerProperties() == null ? null : this.innerProperties().authCredentials();
    }

    public CredentialSetInner withAuthCredentials(List<AuthCredential> authCredentials) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CredentialSetProperties();
        }
        this.innerProperties().withAuthCredentials(authCredentials);
        return this;
    }

    public OffsetDateTime creationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().creationDate();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static CredentialSetInner fromJson(JsonReader jsonReader) throws IOException {
        return (CredentialSetInner)((Object)jsonReader.readObject(reader -> {
            CredentialSetInner deserializedCredentialSetInner = new CredentialSetInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCredentialSetInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedCredentialSetInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCredentialSetInner.type = reader.getString();
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedCredentialSetInner.identity = IdentityProperties.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCredentialSetInner.innerProperties = CredentialSetProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedCredentialSetInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCredentialSetInner;
        }));
    }
}

