/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.WebhookAction;
import com.azure.resourcemanager.containerregistry.models.WebhookStatus;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class WebhookPropertiesUpdateParameters
implements JsonSerializable<WebhookPropertiesUpdateParameters> {
    private String serviceUri;
    private Map<String, String> customHeaders;
    private WebhookStatus status;
    private String scope;
    private List<WebhookAction> actions;

    public String serviceUri() {
        return this.serviceUri;
    }

    public WebhookPropertiesUpdateParameters withServiceUri(String serviceUri) {
        this.serviceUri = serviceUri;
        return this;
    }

    public Map<String, String> customHeaders() {
        return this.customHeaders;
    }

    public WebhookPropertiesUpdateParameters withCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders = customHeaders;
        return this;
    }

    public WebhookStatus status() {
        return this.status;
    }

    public WebhookPropertiesUpdateParameters withStatus(WebhookStatus status) {
        this.status = status;
        return this;
    }

    public String scope() {
        return this.scope;
    }

    public WebhookPropertiesUpdateParameters withScope(String scope) {
        this.scope = scope;
        return this;
    }

    public List<WebhookAction> actions() {
        return this.actions;
    }

    public WebhookPropertiesUpdateParameters withActions(List<WebhookAction> actions) {
        this.actions = actions;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serviceUri", this.serviceUri);
        jsonWriter.writeMapField("customHeaders", this.customHeaders, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("scope", this.scope);
        jsonWriter.writeArrayField("actions", this.actions, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static WebhookPropertiesUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (WebhookPropertiesUpdateParameters)jsonReader.readObject(reader -> {
            WebhookPropertiesUpdateParameters deserializedWebhookPropertiesUpdateParameters = new WebhookPropertiesUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serviceUri".equals(fieldName)) {
                    deserializedWebhookPropertiesUpdateParameters.serviceUri = reader.getString();
                    continue;
                }
                if ("customHeaders".equals(fieldName)) {
                    Map customHeaders;
                    deserializedWebhookPropertiesUpdateParameters.customHeaders = customHeaders = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedWebhookPropertiesUpdateParameters.status = WebhookStatus.fromString(reader.getString());
                    continue;
                }
                if ("scope".equals(fieldName)) {
                    deserializedWebhookPropertiesUpdateParameters.scope = reader.getString();
                    continue;
                }
                if ("actions".equals(fieldName)) {
                    List actions;
                    deserializedWebhookPropertiesUpdateParameters.actions = actions = reader.readArray(reader1 -> WebhookAction.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebhookPropertiesUpdateParameters;
        });
    }
}

