/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.CustomRegistryCredentials;
import com.azure.resourcemanager.containerregistry.models.SourceRegistryCredentials;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class Credentials {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(Credentials.class);
    @JsonProperty(value="sourceRegistry")
    private SourceRegistryCredentials sourceRegistry;
    @JsonProperty(value="customRegistries")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, CustomRegistryCredentials> customRegistries;

    public SourceRegistryCredentials sourceRegistry() {
        return this.sourceRegistry;
    }

    public Credentials withSourceRegistry(SourceRegistryCredentials sourceRegistry) {
        this.sourceRegistry = sourceRegistry;
        return this;
    }

    public Map<String, CustomRegistryCredentials> customRegistries() {
        return this.customRegistries;
    }

    public Credentials withCustomRegistries(Map<String, CustomRegistryCredentials> customRegistries) {
        this.customRegistries = customRegistries;
        return this;
    }

    public void validate() {
        if (this.sourceRegistry() != null) {
            this.sourceRegistry().validate();
        }
        if (this.customRegistries() != null) {
            this.customRegistries().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }
}

