/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.fluent.models.RunInner;
import com.azure.resourcemanager.containerregistry.fluent.models.TaskRunPropertiesInner;
import com.azure.resourcemanager.containerregistry.models.IdentityProperties;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.azure.resourcemanager.containerregistry.models.RunRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class TaskRunInner
extends ProxyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(TaskRunInner.class);
    @JsonProperty(value="identity")
    private IdentityProperties identity;
    @JsonProperty(value="properties")
    private TaskRunPropertiesInner innerProperties;
    @JsonProperty(value="location")
    private String location;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    public IdentityProperties identity() {
        return this.identity;
    }

    public TaskRunInner withIdentity(IdentityProperties identity) {
        this.identity = identity;
        return this;
    }

    private TaskRunPropertiesInner innerProperties() {
        return this.innerProperties;
    }

    public String location() {
        return this.location;
    }

    public TaskRunInner withLocation(String location) {
        this.location = location;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public RunRequest runRequest() {
        return this.innerProperties() == null ? null : this.innerProperties().runRequest();
    }

    public TaskRunInner withRunRequest(RunRequest runRequest) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskRunPropertiesInner();
        }
        this.innerProperties().withRunRequest(runRequest);
        return this;
    }

    public RunInner runResult() {
        return this.innerProperties() == null ? null : this.innerProperties().runResult();
    }

    public String forceUpdateTag() {
        return this.innerProperties() == null ? null : this.innerProperties().forceUpdateTag();
    }

    public TaskRunInner withForceUpdateTag(String forceUpdateTag) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskRunPropertiesInner();
        }
        this.innerProperties().withForceUpdateTag(forceUpdateTag);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

