/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.ImportPipelineSourceProperties;
import com.azure.resourcemanager.containerregistry.models.PipelineOptions;
import com.azure.resourcemanager.containerregistry.models.PipelineTriggerProperties;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ImportPipelineProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ImportPipelineProperties.class);
    @JsonProperty(value="source", required=true)
    private ImportPipelineSourceProperties source;
    @JsonProperty(value="trigger")
    private PipelineTriggerProperties trigger;
    @JsonProperty(value="options")
    private List<PipelineOptions> options;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    public ImportPipelineSourceProperties source() {
        return this.source;
    }

    public ImportPipelineProperties withSource(ImportPipelineSourceProperties source) {
        this.source = source;
        return this;
    }

    public PipelineTriggerProperties trigger() {
        return this.trigger;
    }

    public ImportPipelineProperties withTrigger(PipelineTriggerProperties trigger) {
        this.trigger = trigger;
        return this;
    }

    public List<PipelineOptions> options() {
        return this.options;
    }

    public ImportPipelineProperties withOptions(List<PipelineOptions> options) {
        this.options = options;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.source() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property source in model ImportPipelineProperties"));
        }
        this.source().validate();
        if (this.trigger() != null) {
            this.trigger().validate();
        }
    }
}

