/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.computelimit.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.computelimit.ComputeLimitManager;
import com.azure.resourcemanager.computelimit.fluent.models.SharedLimitInner;
import com.azure.resourcemanager.computelimit.models.SharedLimit;
import com.azure.resourcemanager.computelimit.models.SharedLimitProperties;

public final class SharedLimitImpl
implements SharedLimit,
SharedLimit.Definition {
    private SharedLimitInner innerObject;
    private final ComputeLimitManager serviceManager;
    private String location;
    private String name;

    SharedLimitImpl(SharedLimitInner innerObject, ComputeLimitManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SharedLimitProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public SharedLimitInner innerModel() {
        return this.innerObject;
    }

    private ComputeLimitManager manager() {
        return this.serviceManager;
    }

    @Override
    public SharedLimitImpl withExistingLocation(String location) {
        this.location = location;
        return this;
    }

    @Override
    public SharedLimit create() {
        this.innerObject = (SharedLimitInner)((Object)this.serviceManager.serviceClient().getSharedLimits().createWithResponse(this.location, this.name, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public SharedLimit create(Context context) {
        this.innerObject = (SharedLimitInner)((Object)this.serviceManager.serviceClient().getSharedLimits().createWithResponse(this.location, this.name, this.innerModel(), context).getValue());
        return this;
    }

    SharedLimitImpl(String name, ComputeLimitManager serviceManager) {
        this.innerObject = new SharedLimitInner();
        this.serviceManager = serviceManager;
        this.name = name;
    }

    @Override
    public SharedLimit refresh() {
        this.innerObject = (SharedLimitInner)((Object)this.serviceManager.serviceClient().getSharedLimits().getWithResponse(this.location, this.name, Context.NONE).getValue());
        return this;
    }

    @Override
    public SharedLimit refresh(Context context) {
        this.innerObject = (SharedLimitInner)((Object)this.serviceManager.serviceClient().getSharedLimits().getWithResponse(this.location, this.name, context).getValue());
        return this;
    }

    @Override
    public SharedLimitImpl withProperties(SharedLimitProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

