/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.computelimit.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.computelimit.ComputeLimitManager;
import com.azure.resourcemanager.computelimit.fluent.models.GuestSubscriptionInner;
import com.azure.resourcemanager.computelimit.models.GuestSubscription;
import com.azure.resourcemanager.computelimit.models.GuestSubscriptionProperties;

public final class GuestSubscriptionImpl
implements GuestSubscription,
GuestSubscription.Definition {
    private GuestSubscriptionInner innerObject;
    private final ComputeLimitManager serviceManager;
    private String location;
    private String guestSubscriptionId;

    GuestSubscriptionImpl(GuestSubscriptionInner innerObject, ComputeLimitManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public GuestSubscriptionProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public GuestSubscriptionInner innerModel() {
        return this.innerObject;
    }

    private ComputeLimitManager manager() {
        return this.serviceManager;
    }

    @Override
    public GuestSubscriptionImpl withExistingLocation(String location) {
        this.location = location;
        return this;
    }

    @Override
    public GuestSubscription create() {
        this.innerObject = (GuestSubscriptionInner)((Object)this.serviceManager.serviceClient().getGuestSubscriptions().createWithResponse(this.location, this.guestSubscriptionId, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public GuestSubscription create(Context context) {
        this.innerObject = (GuestSubscriptionInner)((Object)this.serviceManager.serviceClient().getGuestSubscriptions().createWithResponse(this.location, this.guestSubscriptionId, this.innerModel(), context).getValue());
        return this;
    }

    GuestSubscriptionImpl(String name, ComputeLimitManager serviceManager) {
        this.innerObject = new GuestSubscriptionInner();
        this.serviceManager = serviceManager;
        this.guestSubscriptionId = name;
    }

    @Override
    public GuestSubscription refresh() {
        this.innerObject = (GuestSubscriptionInner)((Object)this.serviceManager.serviceClient().getGuestSubscriptions().getWithResponse(this.location, this.guestSubscriptionId, Context.NONE).getValue());
        return this;
    }

    @Override
    public GuestSubscription refresh(Context context) {
        this.innerObject = (GuestSubscriptionInner)((Object)this.serviceManager.serviceClient().getGuestSubscriptions().getWithResponse(this.location, this.guestSubscriptionId, context).getValue());
        return this;
    }

    @Override
    public GuestSubscriptionImpl withProperties(GuestSubscriptionProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

