/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.computefleet.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.computefleet.models.DiskControllerTypes;
import com.azure.resourcemanager.computefleet.models.ImageReference;
import com.azure.resourcemanager.computefleet.models.VirtualMachineScaleSetDataDisk;
import com.azure.resourcemanager.computefleet.models.VirtualMachineScaleSetOSDisk;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineScaleSetStorageProfile
implements JsonSerializable<VirtualMachineScaleSetStorageProfile> {
    private ImageReference imageReference;
    private VirtualMachineScaleSetOSDisk osDisk;
    private List<VirtualMachineScaleSetDataDisk> dataDisks;
    private DiskControllerTypes diskControllerType;

    public ImageReference imageReference() {
        return this.imageReference;
    }

    public VirtualMachineScaleSetStorageProfile withImageReference(ImageReference imageReference) {
        this.imageReference = imageReference;
        return this;
    }

    public VirtualMachineScaleSetOSDisk osDisk() {
        return this.osDisk;
    }

    public VirtualMachineScaleSetStorageProfile withOsDisk(VirtualMachineScaleSetOSDisk osDisk) {
        this.osDisk = osDisk;
        return this;
    }

    public List<VirtualMachineScaleSetDataDisk> dataDisks() {
        return this.dataDisks;
    }

    public VirtualMachineScaleSetStorageProfile withDataDisks(List<VirtualMachineScaleSetDataDisk> dataDisks) {
        this.dataDisks = dataDisks;
        return this;
    }

    public DiskControllerTypes diskControllerType() {
        return this.diskControllerType;
    }

    public VirtualMachineScaleSetStorageProfile withDiskControllerType(DiskControllerTypes diskControllerType) {
        this.diskControllerType = diskControllerType;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("imageReference", (JsonSerializable)this.imageReference);
        jsonWriter.writeJsonField("osDisk", (JsonSerializable)this.osDisk);
        jsonWriter.writeArrayField("dataDisks", this.dataDisks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("diskControllerType", this.diskControllerType == null ? null : this.diskControllerType.toString());
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineScaleSetStorageProfile fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineScaleSetStorageProfile)jsonReader.readObject(reader -> {
            VirtualMachineScaleSetStorageProfile deserializedVirtualMachineScaleSetStorageProfile = new VirtualMachineScaleSetStorageProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("imageReference".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetStorageProfile.imageReference = ImageReference.fromJson(reader);
                    continue;
                }
                if ("osDisk".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetStorageProfile.osDisk = VirtualMachineScaleSetOSDisk.fromJson(reader);
                    continue;
                }
                if ("dataDisks".equals(fieldName)) {
                    List dataDisks;
                    deserializedVirtualMachineScaleSetStorageProfile.dataDisks = dataDisks = reader.readArray(reader1 -> VirtualMachineScaleSetDataDisk.fromJson(reader1));
                    continue;
                }
                if ("diskControllerType".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetStorageProfile.diskControllerType = DiskControllerTypes.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineScaleSetStorageProfile;
        });
    }
}

