/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.computefleet.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.computefleet.models.DeleteOptions;
import com.azure.resourcemanager.computefleet.models.IPVersion;
import com.azure.resourcemanager.computefleet.models.VirtualMachineScaleSetIpTag;
import com.azure.resourcemanager.computefleet.models.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineScaleSetPublicIPAddressConfigurationProperties
implements JsonSerializable<VirtualMachineScaleSetPublicIPAddressConfigurationProperties> {
    private Integer idleTimeoutInMinutes;
    private VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings dnsSettings;
    private List<VirtualMachineScaleSetIpTag> ipTags;
    private SubResource publicIPPrefix;
    private IPVersion publicIPAddressVersion;
    private DeleteOptions deleteOption;

    public Integer idleTimeoutInMinutes() {
        return this.idleTimeoutInMinutes;
    }

    public VirtualMachineScaleSetPublicIPAddressConfigurationProperties withIdleTimeoutInMinutes(Integer idleTimeoutInMinutes) {
        this.idleTimeoutInMinutes = idleTimeoutInMinutes;
        return this;
    }

    public VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings dnsSettings() {
        return this.dnsSettings;
    }

    public VirtualMachineScaleSetPublicIPAddressConfigurationProperties withDnsSettings(VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings dnsSettings) {
        this.dnsSettings = dnsSettings;
        return this;
    }

    public List<VirtualMachineScaleSetIpTag> ipTags() {
        return this.ipTags;
    }

    public VirtualMachineScaleSetPublicIPAddressConfigurationProperties withIpTags(List<VirtualMachineScaleSetIpTag> ipTags) {
        this.ipTags = ipTags;
        return this;
    }

    public SubResource publicIPPrefix() {
        return this.publicIPPrefix;
    }

    public VirtualMachineScaleSetPublicIPAddressConfigurationProperties withPublicIPPrefix(SubResource publicIPPrefix) {
        this.publicIPPrefix = publicIPPrefix;
        return this;
    }

    public IPVersion publicIPAddressVersion() {
        return this.publicIPAddressVersion;
    }

    public VirtualMachineScaleSetPublicIPAddressConfigurationProperties withPublicIPAddressVersion(IPVersion publicIPAddressVersion) {
        this.publicIPAddressVersion = publicIPAddressVersion;
        return this;
    }

    public DeleteOptions deleteOption() {
        return this.deleteOption;
    }

    public VirtualMachineScaleSetPublicIPAddressConfigurationProperties withDeleteOption(DeleteOptions deleteOption) {
        this.deleteOption = deleteOption;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("idleTimeoutInMinutes", (Number)this.idleTimeoutInMinutes);
        jsonWriter.writeJsonField("dnsSettings", (JsonSerializable)this.dnsSettings);
        jsonWriter.writeArrayField("ipTags", this.ipTags, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("publicIPPrefix", (JsonSerializable)this.publicIPPrefix);
        jsonWriter.writeStringField("publicIPAddressVersion", this.publicIPAddressVersion == null ? null : this.publicIPAddressVersion.toString());
        jsonWriter.writeStringField("deleteOption", this.deleteOption == null ? null : this.deleteOption.toString());
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineScaleSetPublicIPAddressConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineScaleSetPublicIPAddressConfigurationProperties)jsonReader.readObject(reader -> {
            VirtualMachineScaleSetPublicIPAddressConfigurationProperties deserializedVirtualMachineScaleSetPublicIPAddressConfigurationProperties = new VirtualMachineScaleSetPublicIPAddressConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("idleTimeoutInMinutes".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetPublicIPAddressConfigurationProperties.idleTimeoutInMinutes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("dnsSettings".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetPublicIPAddressConfigurationProperties.dnsSettings = VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings.fromJson(reader);
                    continue;
                }
                if ("ipTags".equals(fieldName)) {
                    List ipTags;
                    deserializedVirtualMachineScaleSetPublicIPAddressConfigurationProperties.ipTags = ipTags = reader.readArray(reader1 -> VirtualMachineScaleSetIpTag.fromJson(reader1));
                    continue;
                }
                if ("publicIPPrefix".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetPublicIPAddressConfigurationProperties.publicIPPrefix = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("publicIPAddressVersion".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetPublicIPAddressConfigurationProperties.publicIPAddressVersion = IPVersion.fromString(reader.getString());
                    continue;
                }
                if ("deleteOption".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetPublicIPAddressConfigurationProperties.deleteOption = DeleteOptions.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineScaleSetPublicIPAddressConfigurationProperties;
        });
    }
}

